/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.nucleus;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.SetMultimap;
import com.google.common.math.IntMath;
import dmg.cells.nucleus.CellAddressCore;
import dmg.cells.nucleus.CellRoute;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.dcache.util.ColumnWriter;

public class CellRoutingTable
implements Serializable {
    private static final long serialVersionUID = -1456280129622980563L;
    private final ListMultimap<String, CellRoute> _queue = ArrayListMultimap.create();
    private final SetMultimap<String, CellRoute> _domain = LinkedHashMultimap.create();
    private final SetMultimap<String, CellRoute> _exact = LinkedHashMultimap.create();
    private final Map<String, CopyOnWriteArraySet<CellRoute>> _topic = new HashMap<String, CopyOnWriteArraySet<CellRoute>>();
    private final AtomicReference<CellRoute> _dumpster = new AtomicReference();
    private final List<CellRoute> _default = new ArrayList<CellRoute>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(CellRoute route) throws IllegalArgumentException {
        switch (route.getRouteType()) {
            case 1: 
            case 6: {
                String dest = route.getCellName() + "@" + route.getDomainName();
                SetMultimap<String, CellRoute> setMultimap = this._exact;
                synchronized (setMultimap) {
                    if (!this._exact.put((Object)dest, (Object)route)) {
                        throw new IllegalArgumentException("Duplicated route entry for : " + dest);
                    }
                    break;
                }
            }
            case 2: {
                String dest = route.getCellName();
                ListMultimap<String, CellRoute> listMultimap = this._queue;
                synchronized (listMultimap) {
                    if (this._queue.containsEntry((Object)dest, (Object)route)) {
                        throw new IllegalArgumentException("Duplicated route entry for : " + dest);
                    }
                    this._queue.put((Object)dest, (Object)route);
                    break;
                }
            }
            case 7: {
                String dest = route.getCellName();
                Map<String, CopyOnWriteArraySet<CellRoute>> map = this._topic;
                synchronized (map) {
                    if (!this._topic.computeIfAbsent(dest, key -> new CopyOnWriteArraySet()).add(route)) {
                        throw new IllegalArgumentException("Duplicated route entry for : " + dest);
                    }
                    break;
                }
            }
            case 3: {
                String dest = route.getDomainName();
                SetMultimap<String, CellRoute> setMultimap = this._domain;
                synchronized (setMultimap) {
                    if (!this._domain.put((Object)dest, (Object)route)) {
                        throw new IllegalArgumentException("Duplicated route entry for : " + dest);
                    }
                    break;
                }
            }
            case 4: {
                List<CellRoute> list = this._default;
                synchronized (list) {
                    if (!this._default.contains(route)) {
                        this._default.add(route);
                    }
                    break;
                }
            }
            case 5: {
                if (this._dumpster.compareAndSet(null, route)) break;
                throw new IllegalArgumentException("Duplicated route entry for dumpster");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(CellRoute route) throws IllegalArgumentException {
        switch (route.getRouteType()) {
            case 1: 
            case 6: {
                String dest = route.getCellName() + "@" + route.getDomainName();
                SetMultimap<String, CellRoute> setMultimap = this._exact;
                synchronized (setMultimap) {
                    if (!this._exact.remove((Object)dest, (Object)route)) {
                        throw new IllegalArgumentException("Route entry not found for : " + dest);
                    }
                    break;
                }
            }
            case 2: {
                String dest = route.getCellName();
                ListMultimap<String, CellRoute> listMultimap = this._queue;
                synchronized (listMultimap) {
                    if (!this._queue.remove((Object)dest, (Object)route)) {
                        throw new IllegalArgumentException("Route entry not found for : " + dest);
                    }
                    break;
                }
            }
            case 7: {
                String dest = route.getCellName();
                Map<String, CopyOnWriteArraySet<CellRoute>> map = this._topic;
                synchronized (map) {
                    Set routes = this._topic.get(dest);
                    if (!routes.remove(route)) {
                        throw new IllegalArgumentException("Route entry not found for : " + dest);
                    }
                    if (routes.isEmpty()) {
                        this._topic.remove(dest);
                    }
                    break;
                }
            }
            case 3: {
                String dest = route.getDomainName();
                SetMultimap<String, CellRoute> setMultimap = this._domain;
                synchronized (setMultimap) {
                    if (!this._domain.remove((Object)dest, (Object)route)) {
                        throw new IllegalArgumentException("Route entry not found for : " + dest);
                    }
                    break;
                }
            }
            case 4: {
                List<CellRoute> list = this._default;
                synchronized (list) {
                    if (!this._default.remove(route)) {
                        throw new IllegalArgumentException("Route entry not found for default");
                    }
                    break;
                }
            }
            case 5: {
                CellRoute currentDumpster = this._dumpster.get();
                if (Objects.equals(currentDumpster, route) && this._dumpster.compareAndSet(currentDumpster, null)) break;
                throw new IllegalArgumentException("Route entry not found dumpster");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CellRoute> delete(CellAddressCore target) {
        ArrayList<CellRoute> deleted = new ArrayList<CellRoute>();
        Object object = this._exact;
        synchronized (object) {
            this.delete(this._exact.values(), target, deleted);
        }
        object = this._queue;
        synchronized (object) {
            this.delete(this._queue.values(), target, deleted);
        }
        object = this._domain;
        synchronized (object) {
            this.delete(this._domain.values(), target, deleted);
        }
        object = this._topic;
        synchronized (object) {
            Iterator<CopyOnWriteArraySet<CellRoute>> iterator = this._topic.values().iterator();
            while (iterator.hasNext()) {
                Set routes = iterator.next();
                List toRemove = routes.stream().filter(route -> route.getTarget().equals(target)).collect(Collectors.toList());
                routes.removeAll(toRemove);
                if (routes.isEmpty()) {
                    iterator.remove();
                }
                deleted.addAll(toRemove);
            }
        }
        object = this._default;
        synchronized (object) {
            this.delete(this._default, target, deleted);
        }
        return deleted;
    }

    private void delete(Collection<CellRoute> values, CellAddressCore addr, Collection<CellRoute> deleted) {
        Iterator<CellRoute> iterator = values.iterator();
        while (iterator.hasNext()) {
            CellRoute route = iterator.next();
            if (!route.getTarget().equals(addr)) continue;
            iterator.remove();
            deleted.add(route);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CellRoute find(CellAddressCore addr, Optional<String> zone, boolean allowRemote) {
        Optional route;
        String cellName = addr.getCellName();
        String domainName = addr.getCellDomainName();
        Object object = this._exact;
        synchronized (object) {
            route = this._exact.get((Object)(cellName + "@" + domainName)).stream().findFirst();
        }
        if (route.isPresent()) {
            return (CellRoute)route.get();
        }
        if (domainName.equals("local")) {
            object = this._queue;
            synchronized (object) {
                List routes = this._queue.get((Object)cellName);
                ThreadLocalRandom random = ThreadLocalRandom.current();
                if (!allowRemote) {
                    CellRoute[] localRoutes = (CellRoute[])routes.stream().filter(r -> !r.getTarget().isDomainAddress()).toArray(CellRoute[]::new);
                    CellRoute cellRoute = localRoutes.length > 0 ? localRoutes[((Random)random).nextInt(localRoutes.length)] : null;
                    return cellRoute;
                }
                if (!routes.isEmpty()) {
                    CellRoute[] localRoutes;
                    if (zone.isPresent() && (localRoutes = (CellRoute[])routes.stream().filter(r -> r.getZone().equals(zone)).toArray(CellRoute[]::new)).length > 0) {
                        return localRoutes[((Random)random).nextInt(localRoutes.length)];
                    }
                    return (CellRoute)routes.get(((Random)random).nextInt(routes.size()));
                }
            }
        }
        object = this._domain;
        synchronized (object) {
            route = this._domain.get((Object)domainName).stream().findFirst();
        }
        if (route.isPresent()) {
            return (CellRoute)route.get();
        }
        object = this._default;
        synchronized (object) {
            Optional<CellRoute> defaultZonedRoute;
            if (this._default.isEmpty()) {
                return null;
            }
            if (zone.isPresent() && (defaultZonedRoute = this._default.stream().filter(r -> r.getZone().equals(zone)).findAny()).isPresent()) {
                return defaultZonedRoute.get();
            }
            return this._default.get(IntMath.mod((int)addr.hashCode(), (int)this._default.size()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<CellRoute> findTopicRoutes(CellAddressCore addr) {
        CopyOnWriteArraySet<CellRoute> routes;
        String cellName = addr.getCellName();
        String domainName = addr.getCellDomainName();
        if (!domainName.equals("local")) {
            return Collections.emptySet();
        }
        Map<String, CopyOnWriteArraySet<CellRoute>> map = this._topic;
        synchronized (map) {
            routes = this._topic.get(cellName);
        }
        return routes != null ? routes : Collections.emptySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        ColumnWriter writer = new ColumnWriter().header("CELL").left("cell").space().header("DOMAIN").left("domain").space().header("GATEWAY").left("gateway").space().header("TYPE").left("type");
        Consumer<CellRoute> append = route -> writer.row().value("cell", (Object)route.getCellName()).value("domain", (Object)route.getDomainName()).value("gateway", (Object)route.getTarget()).value("type", (Object)route.getRouteTypeName());
        Object object = this._topic;
        synchronized (object) {
            this._topic.values().forEach(routes -> routes.forEach(append));
        }
        object = this._exact;
        synchronized (object) {
            this._exact.values().forEach(append);
        }
        object = this._queue;
        synchronized (object) {
            this._queue.values().forEach(append);
        }
        object = this._domain;
        synchronized (object) {
            this._domain.values().forEach(append);
        }
        object = this._default;
        synchronized (object) {
            this._default.forEach(append);
        }
        CellRoute dumpsterRoute = this._dumpster.get();
        if (dumpsterRoute != null) {
            append.accept(dumpsterRoute);
        }
        return writer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CellRoute[] getRoutingList() {
        ArrayList<CellRoute> routes = new ArrayList<CellRoute>();
        Object object = this._topic;
        synchronized (object) {
            this._topic.values().forEach(routes::addAll);
        }
        object = this._exact;
        synchronized (object) {
            routes.addAll(this._exact.values());
        }
        object = this._queue;
        synchronized (object) {
            routes.addAll(this._queue.values());
        }
        object = this._domain;
        synchronized (object) {
            routes.addAll(this._domain.values());
        }
        object = this._default;
        synchronized (object) {
            routes.addAll(this._default);
        }
        CellRoute dumpsterRoute = this._dumpster.get();
        if (dumpsterRoute != null) {
            routes.add(dumpsterRoute);
        }
        return (CellRoute[])routes.toArray(CellRoute[]::new);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasDefaultRoute() {
        List<CellRoute> list = this._default;
        synchronized (list) {
            return !this._default.isEmpty();
        }
    }
}

