/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.nucleus;

import dmg.cells.nucleus.CellEndpoint;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.Reply;
import java.io.Serializable;
import java.util.Objects;

public class DelayedReply
implements Reply {
    private static final long serialVersionUID = -236693000550935733L;
    private CellEndpoint _endpoint;
    private CellMessage _envelope;
    private Serializable _msg;

    @Override
    public synchronized void deliver(CellEndpoint endpoint, CellMessage envelope) {
        this._endpoint = Objects.requireNonNull(endpoint);
        this._envelope = Objects.requireNonNull(envelope);
        if (this._msg != null) {
            this.send();
        }
    }

    public synchronized void reply(Serializable msg) {
        this._msg = msg;
        if (this._envelope != null) {
            this.send();
        }
        this.notifyAll();
    }

    protected synchronized void send() {
        this._envelope.revertDirection();
        this._envelope.setMessageObject(this._msg);
        this._endpoint.sendMessage(this._envelope, new CellEndpoint.SendFlag[0]);
        this._envelope = null;
        this._endpoint = null;
    }

    public synchronized Serializable take() throws InterruptedException {
        while (this._msg == null) {
            this.wait();
        }
        return this._msg;
    }
}

