/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.nucleus;

import com.google.common.base.Preconditions;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import org.nustaq.serialization.FSTConfiguration;

public final class MsgSerializerFst {
    private static final int INITIAL_BUFFER_SIZE = 256;
    private static final FSTConfiguration fstConf = FSTConfiguration.createDefaultConfiguration();
    private static final byte[] FST_MESSAGE_HEADER;

    private MsgSerializerFst() {
    }

    public static byte[] encode(Object message) {
        Preconditions.checkState((message != null ? 1 : 0) != 0, (Object)"Unencoded message payload is null.");
        byte[] serialized = fstConf.asByteArray(message);
        ByteArrayOutputStream array = new ByteArrayOutputStream(256);
        array.write(FST_MESSAGE_HEADER, 0, FST_MESSAGE_HEADER.length);
        array.write(serialized, 0, serialized.length);
        return array.toByteArray();
    }

    public static Object decode(byte[] messageStream) {
        Preconditions.checkState((messageStream != null ? 1 : 0) != 0, (Object)"Encoded message payload is null.");
        Preconditions.checkState((boolean)MsgSerializerFst.isFstEncoded(messageStream));
        return fstConf.asObject(Arrays.copyOfRange(messageStream, 4, messageStream.length));
    }

    public static boolean isFstEncoded(byte[] messageStream) {
        return messageStream[0] == FST_MESSAGE_HEADER[0] && messageStream[1] == FST_MESSAGE_HEADER[1] && messageStream[2] == FST_MESSAGE_HEADER[2] && messageStream[3] == FST_MESSAGE_HEADER[3];
    }

    static {
        fstConf.setPreferSpeed(true);
        FST_MESSAGE_HEADER = new byte[]{5, 77, 0, 1};
    }
}

