/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.nucleus;

import com.google.common.base.Preconditions;
import dmg.cells.nucleus.SerializationException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public final class MsgSerializerJos {
    private static final int INITIAL_BUFFER_SIZE = 256;

    private MsgSerializerJos() {
    }

    public static byte[] encode(Object message) {
        Preconditions.checkState((message != null ? 1 : 0) != 0, (Object)"Unencoded message payload is null.");
        ByteArrayOutputStream array = new ByteArrayOutputStream(256);
        try (ObjectOutputStream out = new ObjectOutputStream(array);){
            out.writeObject(message);
        }
        catch (InvalidClassException e) {
            throw new SerializationException("Failed to serialize object: " + e + "(this is usually a bug)", e);
        }
        catch (NotSerializableException e) {
            throw new SerializationException("Failed to serialize object because the object is not serializable (this is usually a bug)", e);
        }
        catch (IOException e) {
            throw new SerializationException("Failed to serialize object: " + e, e);
        }
        return array.toByteArray();
    }

    public static Object decode(byte[] messageStream) {
        Object object;
        Preconditions.checkState((messageStream != null ? 1 : 0) != 0, (Object)"Encoded message payload is null.");
        ObjectInputStream stream = new ObjectInputStream(new ByteArrayInputStream(messageStream));
        try {
            Object decoded;
            object = decoded = stream.readObject();
        }
        catch (Throwable throwable) {
            try {
                try {
                    stream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (ClassNotFoundException e) {
                throw new SerializationException("Failed to deserialize object: The class could not be found. Is there a software version mismatch in your installation?", e);
            }
            catch (IOException e) {
                throw new SerializationException("Failed to deserialize object: " + e, e);
            }
        }
        stream.close();
        return object;
    }
}

