/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.nucleus;

import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellPath;
import dmg.cells.nucleus.SerializationHandler;
import dmg.cells.nucleus.UOID;
import java.io.Serializable;
import javax.annotation.Nullable;

public class NoRouteToCellException
extends Exception {
    private static final long serialVersionUID = -7538969590898439933L;
    private final UOID _uoid;
    private final CellPath _path;
    private final CellMessage _envelope;
    private static final SerializationHandler.Serializer _serializer = SerializationHandler.Serializer.JOS;

    public NoRouteToCellException(CellMessage envelope, String str) {
        super(str);
        this._envelope = envelope.isStreamMode() ? envelope.ensureEncodedWith(_serializer) : envelope.encodeWith(_serializer);
        this._uoid = envelope.getUOID();
        this._path = envelope.getDestinationPath();
    }

    @Override
    public String toString() {
        return "NoRouteToCell[" + this.getMessage() + "]";
    }

    @Override
    public String getMessage() {
        Serializable messageObject = this.getMessageObject();
        if (messageObject == null) {
            return "Failed to deliver message " + this._uoid + " to " + this._path + ": " + super.getMessage();
        }
        return "Failed to deliver " + messageObject.getClass().getSimpleName() + " message " + this._uoid + " to " + this._path + ": " + super.getMessage();
    }

    public UOID getUOID() {
        return this._uoid;
    }

    public CellPath getDestinationPath() {
        return this._path;
    }

    @Nullable
    public CellMessage getCellMessage() {
        return this._envelope != null ? this._envelope.decode() : null;
    }

    @Nullable
    public Serializable getMessageObject() {
        return this._envelope != null ? this._envelope.decode().getMessageObject() : null;
    }
}

