/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.nucleus;

import com.google.common.base.Strings;
import dmg.cells.nucleus.MsgSerializerFst;
import dmg.cells.nucleus.MsgSerializerJos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SerializationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(SerializationHandler.class);

    private SerializationHandler() {
    }

    public static Serializer enumFromConfigString(String configString) {
        String serializerString;
        if (Strings.isNullOrEmpty((String)configString)) {
            return Serializer.JOS;
        }
        switch (serializerString = configString.toLowerCase()) {
            case "experimental": {
                return Serializer.FST;
            }
            case "standard": {
                return Serializer.JOS;
            }
        }
        LOGGER.warn("Unknown serializer specified in configuration. Defaulting to {}.", (Object)Serializer.JOS);
        return Serializer.JOS;
    }

    public static boolean isEncodedWith(byte[] msgStream, Serializer serializer) {
        return serializer == Serializer.FST && MsgSerializerFst.isFstEncoded(msgStream);
    }

    public static byte[] encode(Object message, Serializer serializer) {
        switch (serializer) {
            case JOS: {
                return MsgSerializerJos.encode(message);
            }
            case FST: {
                return MsgSerializerFst.encode(message);
            }
        }
        throw new UnsupportedOperationException("No such serializer. This should never happen.");
    }

    public static Object decode(byte[] messageStream) {
        if (MsgSerializerFst.isFstEncoded(messageStream)) {
            return MsgSerializerFst.decode(messageStream);
        }
        return MsgSerializerJos.decode(messageStream);
    }

    public static enum Serializer {
        UNDEFINED("undefined"),
        JOS("standard"),
        FST("experimental");

        private final String displayName;

        private Serializer(String name) {
            this.displayName = name;
        }

        public String toString() {
            return this.displayName;
        }
    }
}

