/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.nucleus;

import com.google.common.base.Throwables;
import com.google.common.util.concurrent.MoreExecutors;
import dmg.cells.nucleus.CellAdapter;
import dmg.cells.nucleus.CellEndpoint;
import dmg.cells.nucleus.CellInfo;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellNucleus;
import dmg.cells.nucleus.CellShell;
import dmg.cells.nucleus.LogbackShell;
import dmg.cells.nucleus.Reply;
import dmg.cells.nucleus.SerializationHandler;
import dmg.util.AuthorizedString;
import dmg.util.command.Command;
import dmg.util.logback.FilterShell;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.curator.framework.CuratorFramework;
import org.dcache.alarms.AlarmMarkerFactory;
import org.dcache.alarms.PredefinedAlarm;
import org.dcache.util.cli.CommandInterpreter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.remoting.RemoteProxyFailureException;

public class SystemCell
extends CellAdapter
implements Thread.UncaughtExceptionHandler {
    private static final Logger _log = LoggerFactory.getLogger(SystemCell.class);
    private final CellShell _cellShell;
    private final CellNucleus _nucleus;
    private int _packetsReceived;
    private int _packetsAnswered;
    private int _packetsForwarded;
    private int _packetsReplied;
    private int _exceptionCounter;
    private final Runtime _runtime = Runtime.getRuntime();
    private final Semaphore _shutdownLock = new Semaphore(0);

    public static SystemCell create(String cellDomainName, CuratorFramework curatorFramework, Optional<String> zone, SerializationHandler.Serializer serializer) {
        CellNucleus.initCellGlue(cellDomainName, curatorFramework, zone, serializer);
        return new SystemCell();
    }

    protected SystemCell() {
        super("System", "System", "");
        this._nucleus = this.getNucleus();
        this._cellShell = new CellShell(this.getNucleus());
    }

    @Override
    protected void starting() {
        CellNucleus.startCurator();
        this._cellShell.addCommandListener(this);
        this._cellShell.addCommandListener(new LogbackShell());
        this._cellShell.addCommandListener(new FilterShell(this._nucleus.getLoggingThresholds()));
        this._cellShell.addCommandListener(new CommandInterpreter.HelpCommands((CommandInterpreter)this._cellShell));
        this.useInterpreter(false);
        this._runtime.addShutdownHook(new TheKiller());
    }

    @Override
    protected void started() {
        Thread.setDefaultUncaughtExceptionHandler(this);
    }

    @Override
    public void stopped() {
        this.shutdownSystem();
        CellNucleus.shutdownCellGlue();
        _log.info("Opening shutdown lock");
        this._shutdownLock.release();
        System.exit(0);
    }

    @Override
    public String toString() {
        long fm = this._runtime.freeMemory();
        long tm = this._runtime.totalMemory();
        return this.getCellDomainName() + ":IOrec=" + this._packetsReceived + ";IOexc=" + this._exceptionCounter + ";MEM=" + (tm - fm);
    }

    private void shutdownSystem() {
        List<String> names = this._nucleus.getCellNames();
        ArrayList<String> nonSystem = new ArrayList<String>(names.size());
        ArrayList<String> system = new ArrayList<String>(names.size());
        for (String name : names) {
            String cellName;
            CellInfo info = this._nucleus.getCellInfo(name);
            if (info == null || (cellName = info.getCellName()).equals("System")) continue;
            if (info.getCellType().equals("System")) {
                system.add(cellName);
                continue;
            }
            nonSystem.add(cellName);
        }
        _log.info("Will try to shutdown non-system cells {}", nonSystem);
        this.shutdownCells(nonSystem, 5000L, 10000L);
        _log.info("Will try to shutdown remaining cells {}", system);
        this.shutdownCells(system, 5000L, 10000L);
    }

    private void shutdownCells(List<String> cells, long softTimeout, long hardTimeout) {
        long start = System.currentTimeMillis();
        Function<String, Runnable> listeners = name -> () -> {
            long time = System.currentTimeMillis() - start;
            if (time > softTimeout) {
                _log.warn("Killed {} in {}\u00a0ms", name, (Object)time);
            } else {
                _log.info("Killed {}", name);
            }
        };
        Map<String, CompletableFuture> futures = cells.stream().collect(Collectors.toMap(name -> name, this._nucleus::kill));
        futures.forEach((name, future) -> future.thenRunAsync((Runnable)listeners.apply((String)name), MoreExecutors.directExecutor()));
        try {
            CompletableFuture[] futuresAsArray = (CompletableFuture[])futures.values().toArray(CompletableFuture[]::new);
            try {
                CompletableFuture.allOf(futuresAsArray).get(softTimeout, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                futures.forEach((name, future) -> {
                    if (!future.isDone()) {
                        _log.warn("Still waiting for {} to shut down.", name);
                    }
                });
                CompletableFuture.allOf(futuresAsArray).get(hardTimeout - softTimeout, TimeUnit.MILLISECONDS);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (TimeoutException e) {
            futures.forEach((name, future) -> {
                if (!future.isDone()) {
                    CellNucleus.listThreadGroupOf(name);
                }
            });
            CellNucleus.listKillerThreadGroup();
        }
        catch (ExecutionException e) {
            _log.error("Unexpected exception during shutdown.", e.getCause());
        }
    }

    @Override
    public void getInfo(PrintWriter pw) {
        pw.append(" CellDomainName   = ").println(this.getCellDomainName());
        pw.append(" Zone = ").println(this._nucleus.getZone().orElse("(none)"));
        pw.append(" Message payload serializer = ").println((Object)this._nucleus.getMsgSerialization());
        pw.format(" I/O rcv=%d;asw=%d;frw=%d;rpy=%d;exc=%d\n", this._packetsReceived, this._packetsAnswered, this._packetsForwarded, this._packetsReplied, this._exceptionCounter);
        long fm = this._runtime.freeMemory();
        long tm = this._runtime.totalMemory();
        pw.format(" Memory : tot=%d;free=%d;used=%d\n", tm, fm, tm - fm);
        pw.println(" Cells (Threads)");
        for (String name : this._nucleus.getCellNames()) {
            pw.append(" ").append(name).append("(");
            Thread[] threads = this._nucleus.getThreads(name);
            if (threads != null) {
                boolean first = true;
                for (Thread thread : threads) {
                    pw.print(thread.getName());
                    if (first) {
                        first = false;
                        continue;
                    }
                    pw.print(",");
                }
            }
            pw.println(")");
        }
    }

    @Override
    public void messageToForward(CellMessage msg) {
        try {
            this.sendMessage(msg, new CellEndpoint.SendFlag[0]);
            ++this._packetsForwarded;
        }
        catch (RuntimeException eee) {
            ++this._exceptionCounter;
        }
    }

    @Override
    public void messageArrived(CellMessage msg) {
        Object reply;
        _log.info("Message arrived : {}", (Object)msg);
        ++this._packetsReceived;
        if (msg.isReply()) {
            _log.warn("Seems to a bounce : {}", (Object)msg);
            return;
        }
        Serializable obj = msg.getMessageObject();
        if (obj instanceof String) {
            String command = (String)((Object)obj);
            if (command.isEmpty()) {
                return;
            }
            _log.info("Command: {}", (Object)command);
            reply = command.equals("xyzzy") ? "Nothing happens." : this._cellShell.objectCommand2(command);
        } else if (obj instanceof AuthorizedString) {
            AuthorizedString as = (AuthorizedString)obj;
            String command = as.toString();
            if (command.length() < 1) {
                return;
            }
            _log.info("Command(p={}) : {}", (Object)as.getAuthorizedPrincipal(), (Object)command);
            reply = this._cellShell.objectCommand2(command);
        } else {
            return;
        }
        _log.debug("Reply : {}", reply);
        ++this._packetsAnswered;
        try {
            if (reply instanceof Reply) {
                ((Reply)reply).deliver(this, msg);
            } else {
                msg.revertDirection();
                msg.setMessageObject((Serializable)reply);
                this.sendMessage(msg, new CellEndpoint.SendFlag[0]);
                _log.debug("Sending : {}", (Object)msg);
            }
            ++this._packetsReplied;
        }
        catch (RuntimeException e) {
            ++this._exceptionCounter;
        }
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        if (e instanceof VirtualMachineError) {
            this.kill();
            _log.error(AlarmMarkerFactory.getMarker((PredefinedAlarm)PredefinedAlarm.FATAL_JVM_ERROR, (String[])new String[]{this.getCellDomainName(), this.getCellName()}), "Restarting due to fatal JVM error: {}", (Object)e.toString());
            return;
        }
        if (e instanceof RemoteProxyFailureException && e.getCause() instanceof InterruptedException) {
            _log.warn("{} interrupted.", (Object)t.getName());
            return;
        }
        Throwable root = Throwables.getRootCause((Throwable)e);
        if (root instanceof FileNotFoundException && root.getMessage().contains("Too many open files")) {
            _log.error(AlarmMarkerFactory.getMarker((PredefinedAlarm)PredefinedAlarm.OUT_OF_FILE_DESCRIPTORS, (String[])new String[]{this.getCellDomainName(), this.getCellName()}), "Uncaught exception in thread " + t.getName(), e);
            return;
        }
        _log.error("Uncaught exception in thread " + t.getName(), e);
    }

    @Command(name="get hostname", hint="show this dCache-domain hostname", description="Returns the hostname of the computer this (dCache) domain is running at. The hostname returned can be either the fully qualified domain name for this IP address or just 'localhost', if the local host name could not be resolved into an address.")
    public class GetHostnameCommand
    implements Callable<String> {
        @Override
        public String call() {
            try {
                return InetAddress.getLocalHost().getCanonicalHostName();
            }
            catch (UnknownHostException ex) {
                return "localhost";
            }
        }
    }

    private class TheKiller
    extends Thread {
        private TheKiller() {
        }

        @Override
        public void run() {
            _log.info("Running shutdown sequence");
            SystemCell.this.kill();
            _log.info("Kill done, waiting for shutdown lock");
            try {
                SystemCell.this._shutdownLock.acquire();
            }
            catch (Exception exception) {
                // empty catch block
            }
            _log.info("Killer done");
        }
    }
}

