/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.nucleus;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.UUID;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class UOID
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -5940693996555861085L;
    private final long _counter;
    private final long _time;

    public UOID() {
        UUID uuid = UUID.randomUUID();
        this._time = uuid.getMostSignificantBits();
        this._counter = uuid.getLeastSignificantBits();
    }

    UOID(long counter, long time) {
        this._counter = counter;
        this._time = time;
    }

    public Object clone() {
        return this;
    }

    public int hashCode() {
        return Long.hashCode(this._counter);
    }

    public boolean equals(Object x) {
        if (x == this) {
            return true;
        }
        if (!(x instanceof UOID)) {
            return false;
        }
        UOID u = (UOID)x;
        return u._counter == this._counter && u._time == this._time;
    }

    public String toString() {
        return "<" + this._time + ":" + this._counter + ">";
    }

    public void writeTo(DataOutput out) throws IOException {
        out.writeLong(this._counter);
        out.writeLong(this._time);
    }

    public static UOID createFrom(DataInput in) throws IOException {
        return new UOID(in.readLong(), in.readLong());
    }
}

