/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.services;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public class CoreRouteUpdate
implements Serializable {
    private static final long serialVersionUID = 5105253793542041494L;
    private final String[] exports;
    private final String[] topics;
    private final String zone;

    public CoreRouteUpdate(Collection<String> exports, Optional<String> zone) {
        this(exports, Collections.emptyList(), zone);
    }

    public CoreRouteUpdate(Collection<String> exports, Collection<String> topics, Optional<String> zone) {
        this.exports = (String[])exports.stream().distinct().toArray(String[]::new);
        this.topics = (String[])topics.stream().distinct().toArray(String[]::new);
        this.zone = zone.orElse(null);
    }

    public Collection<String> getExports() {
        return Collections.unmodifiableCollection(Arrays.asList(this.exports));
    }

    public Collection<String> getTopics() {
        return Collections.unmodifiableCollection(Arrays.asList(this.topics));
    }

    public Optional<String> getZone() {
        return Optional.ofNullable(this.zone);
    }
}

