/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.services.login;

import dmg.cells.nucleus.Cell;
import dmg.cells.nucleus.CellAdapter;
import dmg.cells.nucleus.CellEndpoint;
import dmg.cells.services.login.StreamEngineLoginCellFactory;
import dmg.util.StreamEngine;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.dcache.util.Args;

public class LegacyLoginCellFactory
extends StreamEngineLoginCellFactory {
    private final Constructor<? extends CellAdapter> _loginConstructor;
    private final String _cellName;

    public LegacyLoginCellFactory(Constructor<? extends CellAdapter> loginConstructor, Args args, CellEndpoint parentEndpoint, String cellName) {
        super(args, parentEndpoint);
        this._cellName = Objects.requireNonNull(cellName);
        this._loginConstructor = Objects.requireNonNull(loginConstructor);
    }

    @Override
    public Cell newCell(StreamEngine engine, String userName) throws InvocationTargetException {
        try {
            CellAdapter cell = this._loginConstructor.newInstance(this._cellName + "-" + userName + "*", engine);
            cell.start().get();
            return cell;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Failed to instantiate login cell: " + this.getName(), e);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new InvocationTargetException(e.getCause(), e.getMessage());
        }
    }

    @Override
    public String getName() {
        return this._loginConstructor.getDeclaringClass().getName();
    }

    protected void doStart() {
        this.notifyStarted();
    }

    protected void doStop() {
        this.notifyStopped();
    }
}

