/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.services.login;

import com.google.common.base.Preconditions;
import dmg.cells.nucleus.Cell;
import dmg.cells.nucleus.CellAdapter;
import dmg.cells.nucleus.CellEndpoint;
import dmg.cells.services.login.LegacyLoginCellFactory;
import dmg.cells.services.login.LegacyWithArgsLoginCellFactory;
import dmg.cells.services.login.LoginCellFactory;
import dmg.cells.services.login.LoginCellProvider;
import dmg.util.StreamEngine;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import org.dcache.util.Args;

public class LegacyLoginCellProvider
implements LoginCellProvider {
    private static final Class<?>[] LOGIN_CON_SIGNATURE = new Class[]{String.class, StreamEngine.class};
    private static final Class<?>[] LOGIN_CON_WITH_ARGS_SIGNATURE = new Class[]{String.class, StreamEngine.class, Args.class};

    @Override
    public int getPriority(String name) {
        try {
            Constructor<Cell> constructor;
            Class<?> clazz = Class.forName(name);
            if (!Cell.class.isAssignableFrom(clazz)) {
                return Integer.MIN_VALUE;
            }
            Class<Cell> loginClass = clazz.asSubclass(Cell.class);
            try {
                constructor = loginClass.getConstructor(LOGIN_CON_WITH_ARGS_SIGNATURE);
            }
            catch (NoSuchMethodException e) {
                constructor = loginClass.getConstructor(LOGIN_CON_SIGNATURE);
            }
            this.checkConstructor(constructor);
        }
        catch (ClassNotFoundException | IllegalArgumentException | NoSuchMethodException e) {
            return Integer.MIN_VALUE;
        }
        return 0;
    }

    @Override
    public LoginCellFactory createFactory(String name, Args args, CellEndpoint parentEndpoint, String parentCellName) {
        try {
            Class<CellAdapter> loginClass = Class.forName(name).asSubclass(CellAdapter.class);
            try {
                Constructor<CellAdapter> constructor = loginClass.getConstructor(LOGIN_CON_WITH_ARGS_SIGNATURE);
                this.checkConstructor(constructor);
                return new LegacyWithArgsLoginCellFactory(constructor, args, parentEndpoint, parentCellName);
            }
            catch (NoSuchMethodException e) {
                Constructor<CellAdapter> constructor = loginClass.getConstructor(LOGIN_CON_SIGNATURE);
                this.checkConstructor(constructor);
                return new LegacyLoginCellFactory(constructor, args, parentEndpoint, parentCellName);
            }
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("No such login cell: " + args.argv(0));
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Login cell lacks appropriate constructor: " + args.argv(0));
        }
    }

    private void checkConstructor(Constructor<? extends Cell> constructor) {
        Preconditions.checkArgument((boolean)Modifier.isPublic(constructor.getDeclaringClass().getModifiers()), (Object)"Login cell is not public");
        Preconditions.checkArgument((boolean)Modifier.isPublic(constructor.getModifiers()), (Object)"Login cell constructor is not public");
        Preconditions.checkArgument((!Modifier.isAbstract(constructor.getModifiers()) ? 1 : 0) != 0, (Object)"Login cell is abstract");
    }
}

