/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.services.login;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.net.InetAddresses;
import dmg.cells.nucleus.AbstractCellComponent;
import dmg.cells.nucleus.CellAddressCore;
import dmg.cells.nucleus.CellCommandListener;
import dmg.cells.nucleus.CellEvent;
import dmg.cells.nucleus.CellEventListener;
import dmg.cells.nucleus.CellInfoProvider;
import dmg.cells.nucleus.CellLifeCycleAware;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellMessageReceiver;
import dmg.cells.nucleus.CellRoute;
import dmg.cells.nucleus.NoRouteToCellException;
import dmg.cells.services.login.LoginBrokerInfo;
import dmg.cells.services.login.LoginBrokerInfoRequest;
import dmg.util.command.Argument;
import dmg.util.command.Command;
import dmg.util.command.Option;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.DoubleSupplier;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.dcache.util.FireAndForgetTask;
import org.dcache.util.NetworkUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginBrokerPublisher
extends AbstractCellComponent
implements CellCommandListener,
CellMessageReceiver,
CellEventListener,
CellLifeCycleAware,
CellInfoProvider {
    private static final Logger _log = LoggerFactory.getLogger(LoginBrokerPublisher.class);
    private CellAddressCore _topic;
    private String _protocolFamily;
    private String _protocolVersion;
    private String _protocolEngine;
    private long _brokerUpdateTime = TimeUnit.MINUTES.toMillis(5L);
    private TimeUnit _brokerUpdateTimeUnit = TimeUnit.MILLISECONDS;
    private double _brokerUpdateThreshold = 0.1;
    private LastEvent _lastEvent = LastEvent.NONE;
    private DoubleSupplier _load = () -> 0.0;
    private Supplier<List<InetAddress>> _addresses = LoginBrokerPublisher.createAnyAddressSupplier();
    private int _port;
    private ScheduledExecutorService _executor;
    private ScheduledFuture<?> _task;
    private String _root = "/";
    private List<String> _readPaths = Collections.emptyList();
    private List<String> _writePaths = Collections.emptyList();
    private boolean _readEnabled = true;
    private boolean _writeEnabled = true;
    private List<InetAddress> _lastAddresses = Collections.emptyList();
    private List<String> _tags = Collections.emptyList();

    private synchronized Optional<LoginBrokerInfo> createLoginBrokerInfo(List<InetAddress> addresses) {
        this._lastAddresses = addresses;
        if (this._task != null && !addresses.isEmpty()) {
            List<String> readPaths = this._readEnabled ? this._readPaths : Collections.emptyList();
            List<String> writePaths = this._writeEnabled ? this._writePaths : Collections.emptyList();
            return Optional.of(new LoginBrokerInfo(this.getCellName(), this.getCellDomainName(), this._protocolFamily, this._protocolVersion, this._protocolEngine, this._root, readPaths, writePaths, this._tags, addresses, this._port, this._load.getAsDouble(), this._brokerUpdateTimeUnit.toMillis(this._brokerUpdateTime)));
        }
        return Optional.empty();
    }

    private synchronized void sendUpdate(Optional<LoginBrokerInfo> info) {
        if (this._topic != null) {
            this._lastEvent = LastEvent.UPDATE_SENT;
            if (info.isPresent()) {
                this.sendMessage(new CellMessage(this._topic, (Serializable)info.get()));
            }
        }
    }

    protected void submitUpdate() {
        this._lastEvent = LastEvent.UPDATE_SUBMITTED;
        this._executor.execute(this::sendUpdate);
    }

    private void sendUpdate() {
        this.sendUpdate(this.createLoginBrokerInfo(this.getAddressSupplier().get()));
    }

    public synchronized void messageArrived(NoRouteToCellException e) {
        CellAddressCore destinationAddress = e.getDestinationPath().getDestinationAddress();
        if (this._topic != null && destinationAddress.equals(this._topic)) {
            switch (this._lastEvent) {
                case UPDATE_SENT: {
                    this._lastEvent = LastEvent.NOROUTE;
                    break;
                }
                case ROUTE_ADDED: {
                    this.submitUpdate();
                    break;
                }
            }
        }
    }

    public LoginBrokerInfo messageArrived(LoginBrokerInfoRequest msg) {
        return this.createLoginBrokerInfo(this.getAddressSupplier().get()).orElse(null);
    }

    @Override
    public synchronized void routeAdded(CellEvent ce) {
        CellRoute route = (CellRoute)ce.getSource();
        if (route.getRouteType() == 7 || route.getRouteType() == 3) {
            switch (this._lastEvent) {
                case UPDATE_SENT: {
                    this._lastEvent = LastEvent.ROUTE_ADDED;
                    break;
                }
                case NOROUTE: {
                    this.submitUpdate();
                    break;
                }
            }
        }
    }

    @Override
    public synchronized void getInfo(PrintWriter pw) {
        if (this._topic == null || this._task == null) {
            pw.println("    Login Broker : DISABLED");
            return;
        }
        pw.println("    LoginBroker      : " + this._topic);
        pw.println("    Protocol Family  : " + this._protocolFamily);
        pw.println("    Protocol Version : " + this._protocolVersion);
        pw.println("    Port             : " + this._port);
        pw.println("    Addresses        : " + this._lastAddresses);
        pw.println("    Tags             : " + this._tags);
        pw.println("    Root             : " + Strings.nullToEmpty((String)this._root));
        pw.println("    Read paths       : " + this._readPaths + (this._readEnabled ? "" : " (disabled)"));
        pw.println("    Write paths      : " + this._writePaths + (this._writeEnabled ? "" : " (disabled)"));
        pw.println("    Update Time      : " + this._brokerUpdateTime + " " + this._brokerUpdateTimeUnit);
        pw.println("    Update Threshold : " + (int)(this._brokerUpdateThreshold * 100.0) + " %");
        pw.println("    Last event       : " + this._lastEvent);
    }

    public void setAddress(@Nullable String host) throws UnknownHostException {
        if (host == null) {
            this.setAddressSupplier(LoginBrokerPublisher.createAnyAddressSupplier());
        } else {
            this.setAddressSupplier(NetworkUtils.hostListAddressSupplier((String)host));
        }
    }

    public synchronized void setSocketAddress(InetSocketAddress socketAddress) {
        InetAddress address = socketAddress.getAddress();
        Preconditions.checkArgument((!address.isMulticastAddress() ? 1 : 0) != 0);
        this._port = socketAddress.getPort();
        if (address.isAnyLocalAddress()) {
            this.setAddressSupplier(LoginBrokerPublisher.createAnyAddressSupplier());
        } else if (NetworkUtils.isInetAddress((String)socketAddress.getHostString())) {
            InetAddress canonicalAddress = NetworkUtils.withCanonicalAddress((InetAddress)address);
            this.setAddressSupplier(() -> Collections.singletonList(canonicalAddress));
        } else {
            this.setAddressSupplier(() -> Collections.singletonList(address));
        }
    }

    public synchronized Supplier<List<InetAddress>> getAddressSupplier() {
        return this._addresses;
    }

    public synchronized void setAddressSupplier(Supplier<List<InetAddress>> addresses) {
        this._addresses = addresses;
        this.rescheduleTask();
    }

    public synchronized void setPort(int port) {
        this._port = port;
        this.rescheduleTask();
    }

    public synchronized void setLoad(int children, int maxChildren) {
        double load = maxChildren > 0 ? (double)children / (double)maxChildren : 0.0;
        this.setLoadProvider(() -> load);
    }

    public synchronized void setLoadProvider(DoubleSupplier load) {
        double diff = Math.abs(this._load.getAsDouble() - load.getAsDouble());
        if (diff > this._brokerUpdateThreshold) {
            this.rescheduleTask();
        }
        this._load = load;
    }

    public synchronized void setTopic(String topic) {
        this._topic = new CellAddressCore(topic);
        this.rescheduleTask();
    }

    public synchronized String getTopic() {
        return Objects.toString(this._topic, null);
    }

    public synchronized void setProtocolFamily(String protocolFamily) {
        this._protocolFamily = protocolFamily;
        this.rescheduleTask();
    }

    public synchronized String getProtocolFamily() {
        return this._protocolFamily;
    }

    public synchronized void setProtocolVersion(String protocolVersion) {
        this._protocolVersion = protocolVersion;
        this.rescheduleTask();
    }

    public synchronized String getProtocolVersion() {
        return this._protocolVersion;
    }

    public synchronized void setProtocolEngine(String protocolEngine) {
        this._protocolEngine = protocolEngine;
        this.rescheduleTask();
    }

    public synchronized String getProtocolEngine() {
        return this._protocolEngine;
    }

    public synchronized void setUpdateThreshold(double threshold) {
        this._brokerUpdateThreshold = threshold;
    }

    public synchronized double getUpdateThreshold() {
        return this._brokerUpdateThreshold;
    }

    public synchronized void setUpdateTime(long time) {
        this._brokerUpdateTime = time;
    }

    public synchronized long getUpdateTime() {
        return this._brokerUpdateTime;
    }

    public synchronized void setUpdateTimeUnit(TimeUnit unit) {
        this._brokerUpdateTimeUnit = unit;
        this.rescheduleTask();
    }

    public synchronized TimeUnit getUpdateTimeUnit() {
        return this._brokerUpdateTimeUnit;
    }

    public synchronized void setRoot(String root) {
        this._root = root;
    }

    public synchronized void setReadPaths(List<String> paths) {
        Preconditions.checkArgument((!paths.stream().anyMatch(String::isEmpty) ? 1 : 0) != 0);
        this._readPaths = paths;
        this.rescheduleTask();
    }

    public synchronized void setWritePaths(List<String> paths) {
        Preconditions.checkArgument((!paths.stream().anyMatch(String::isEmpty) ? 1 : 0) != 0);
        this._writePaths = paths;
        this.rescheduleTask();
    }

    public synchronized void setTags(List<String> tags) {
        this._tags = tags;
        this.rescheduleTask();
    }

    public synchronized void setWriteEnabled(boolean enabled) {
        this._writeEnabled = enabled;
        this.rescheduleTask();
    }

    public synchronized void setReadEnabled(boolean enabled) {
        this._readEnabled = enabled;
        this.rescheduleTask();
    }

    public synchronized void setBrokerUpdateTime(long time, TimeUnit unit) {
        this._brokerUpdateTime = time;
        this._brokerUpdateTimeUnit = unit;
        this.rescheduleTask();
    }

    public synchronized void setExecutor(ScheduledExecutorService executor) {
        this._executor = executor;
        this.rescheduleTask();
    }

    @Override
    public synchronized void afterStart() {
        this.scheduleTask();
    }

    @Override
    public synchronized void beforeStop() {
        if (this._task != null) {
            this._task.cancel(true);
            this._task = null;
        }
        this._addresses = Collections::emptyList;
        this._writeEnabled = false;
        this._readEnabled = false;
        this._load = () -> 1.0;
        this.sendUpdate();
    }

    @GuardedBy(value="this")
    private void rescheduleTask() {
        if (this._task != null) {
            this._task.cancel(false);
            this.scheduleTask();
        }
    }

    private void scheduleTask() {
        this._task = this._executor.scheduleWithFixedDelay((Runnable)new FireAndForgetTask(this::sendUpdate), 0L, this._brokerUpdateTime, this._brokerUpdateTimeUnit);
    }

    public static Supplier<List<InetAddress>> createSingleAddressSupplier(InetAddress address) {
        return () -> Collections.singletonList(address);
    }

    public static Supplier<List<InetAddress>> createAnyAddressSupplier() {
        String localHostAddresses = System.getProperty("org.dcache.net.localaddresses");
        if (!Strings.isNullOrEmpty((String)localHostAddresses)) {
            ArrayList<InetAddress> address = new ArrayList<InetAddress>();
            for (String s : Splitter.on((char)',').omitEmptyStrings().trimResults().split((CharSequence)localHostAddresses)) {
                address.add(NetworkUtils.withCanonicalAddress((InetAddress)InetAddresses.forString((String)s)));
            }
            return () -> address;
        }
        return NetworkUtils.anyAddressSupplier();
    }

    @Command(name="lb enable", hint="resume publishing capabilities", description="Allows to continue publishing read and/or write capabilities. Without additional options, both read and write capabilities will be published in correspondence with the door's configuration.")
    class EnableCommand
    implements Callable<String> {
        @Option(name="read")
        boolean read;
        @Option(name="write")
        boolean write;

        EnableCommand() {
        }

        @Override
        public String call() {
            if (this.read || !this.write) {
                LoginBrokerPublisher.this.setReadEnabled(true);
            }
            if (this.write || !this.read) {
                LoginBrokerPublisher.this.setWriteEnabled(true);
            }
            return "";
        }
    }

    @Command(name="lb disable", hint="suspend publishing capabilities", description="Allows to temporarily suppress publishing of read and write capabilities. It will appear as it the door does not authorize access to any read and/or write paths. Without additional options, both read and write capabilities will be suspended.\n\nNote that this does not actually disable the door. Only the advertized capabilities are changed.")
    class DisableCommand
    implements Callable<String> {
        @Option(name="read")
        boolean read;
        @Option(name="write")
        boolean write;

        DisableCommand() {
        }

        @Override
        public String call() {
            if (this.read || !this.write) {
                LoginBrokerPublisher.this.setReadEnabled(false);
            }
            if (this.write || !this.read) {
                LoginBrokerPublisher.this.setWriteEnabled(false);
            }
            return "";
        }
    }

    @Command(name="lb set tags", hint="set published tags", description="Doors may be tagged and subscribers of door information may filter by these tags.")
    class SetTagCommand
    implements Callable<String> {
        @Argument(required=false)
        String[] tags = new String[0];

        SetTagCommand() {
        }

        @Override
        public String call() {
            LoginBrokerPublisher.this.setTags(Arrays.asList(this.tags));
            return "";
        }
    }

    @Command(name="lb set threshold", hint="set threshold load for OOB updates", description="Sets the relative threshold for sending out-of-band updates. If the load of this for changes by a factor more than this threshold, an immediate update is published.")
    class SetThresholdCommand
    implements Callable<String> {
        @Argument
        double load;

        SetThresholdCommand() {
        }

        @Override
        public String call() {
            LoginBrokerPublisher.this.setUpdateThreshold(this.load);
            return "";
        }
    }

    @Command(name="lb set update", hint="set login broker update frequency", description="Defines how often information about this doors should be published.")
    class SetUpdateCommand
    implements Callable<String> {
        @Argument(metaVar="seconds")
        int time;

        SetUpdateCommand() {
        }

        @Override
        public String call() throws IllegalArgumentException {
            Preconditions.checkArgument((this.time >= 2 ? 1 : 0) != 0, (Object)"Update time out of range.");
            LoginBrokerPublisher.this.setBrokerUpdateTime(this.time, TimeUnit.SECONDS);
            return "";
        }
    }

    private static enum LastEvent {
        NONE,
        UPDATE_SUBMITTED,
        UPDATE_SENT,
        ROUTE_ADDED,
        NOROUTE;

    }
}

