/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.services.login;

import com.google.common.collect.Collections2;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.MoreExecutors;
import dmg.cells.nucleus.CellAddressCore;
import dmg.cells.nucleus.CellCommandListener;
import dmg.cells.nucleus.CellEndpoint;
import dmg.cells.nucleus.CellEvent;
import dmg.cells.nucleus.CellEventListener;
import dmg.cells.nucleus.CellLifeCycleAware;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellMessageAnswerable;
import dmg.cells.nucleus.CellMessageReceiver;
import dmg.cells.nucleus.CellMessageSender;
import dmg.cells.nucleus.CellRoute;
import dmg.cells.nucleus.DelayedReply;
import dmg.cells.nucleus.NoRouteToCellException;
import dmg.cells.services.login.LoginBrokerInfo;
import dmg.cells.services.login.LoginBrokerInfoRequest;
import dmg.cells.services.login.LoginBrokerSource;
import dmg.util.command.Command;
import dmg.util.command.Option;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginBrokerSubscriber
implements CellCommandListener,
CellMessageReceiver,
LoginBrokerSource,
CellMessageSender,
CellEventListener,
CellLifeCycleAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoginBrokerSubscriber.class);
    public static final double EXPIRATION_FACTOR = 2.5;
    private final ConcurrentMap<String, Entry> doorsByIdentity = new ConcurrentHashMap<String, Entry>();
    private final DelayQueue<Entry> queue = new DelayQueue();
    private final Collection<LoginBrokerInfo> unmodifiableView = Collections.unmodifiableCollection(Collections2.transform((Collection)Collections2.filter(this.doorsByIdentity.values(), Entry::isValid), Entry::getLoginBrokerInfo));
    private final ByProtocolMap readDoors = new ByProtocolMap();
    private final ByProtocolMap writeDoors = new ByProtocolMap();
    private CellAddressCore topic;
    private CellEndpoint cellEndpoint;
    private boolean isInitializing;
    private List<String> tags = Collections.emptyList();

    public void setTopic(String topic) {
        this.topic = new CellAddressCore(topic);
    }

    public void setTags(String ... tags) {
        this.tags = Arrays.asList(tags);
    }

    @Override
    public void setCellEndpoint(CellEndpoint endpoint) {
        this.cellEndpoint = endpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void routeAdded(CellEvent ce) {
        CellRoute route = (CellRoute)ce.getSource();
        if (route.getRouteType() == 7 || route.getRouteType() == 4) {
            LoginBrokerSubscriber loginBrokerSubscriber = this;
            synchronized (loginBrokerSubscriber) {
                if (this.isInitializing) {
                    this.requestUpdate();
                }
            }
        }
    }

    @Override
    public void afterStart() {
        if (this.topic != null) {
            this.requestUpdate();
        }
    }

    public void messageArrived(LoginBrokerInfo info) {
        this.expire();
        this.add(new Entry(info));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageArrived(NoRouteToCellException e) {
        if (e.getDestinationPath().getDestinationAddress().equals(this.topic)) {
            LoginBrokerSubscriber loginBrokerSubscriber = this;
            synchronized (loginBrokerSubscriber) {
                this.isInitializing = true;
            }
        }
    }

    private synchronized void requestUpdate() {
        this.isInitializing = false;
        this.cellEndpoint.sendMessage(new CellMessage(this.topic, (Serializable)new LoginBrokerInfoRequest()), new CellEndpoint.SendFlag[0]);
    }

    private void add(Entry entry) {
        if (this.tags.isEmpty() || !Collections.disjoint(this.tags, entry.getLoginBrokerInfo().getTags())) {
            this.addByProtocol(entry.info);
            Entry old = this.doorsByIdentity.put(entry.info.getIdentifier(), entry);
            this.queue.add(entry);
            if (old != null) {
                this.removeByProtocol(old.info);
            }
        }
    }

    private void remove(Entry entry) {
        LoginBrokerInfo info = entry.getLoginBrokerInfo();
        if (this.doorsByIdentity.remove(info.getIdentifier(), entry)) {
            this.removeByProtocol(info);
        } else {
            this.ensureRemovedByProtocol(info);
        }
    }

    private void addByProtocol(LoginBrokerInfo info) {
        info.ifCapableOf(LoginBrokerInfo.Capability.READ, this.readDoors::add);
        info.ifCapableOf(LoginBrokerInfo.Capability.WRITE, this.writeDoors::add);
    }

    private void removeByProtocol(LoginBrokerInfo info) {
        info.ifCapableOf(LoginBrokerInfo.Capability.READ, this.readDoors::remove);
        info.ifCapableOf(LoginBrokerInfo.Capability.WRITE, this.writeDoors::remove);
    }

    private void ensureRemovedByProtocol(LoginBrokerInfo info) {
        info.ifCapableOf(LoginBrokerInfo.Capability.READ, this.readDoors::ensureRemoved);
        info.ifCapableOf(LoginBrokerInfo.Capability.WRITE, this.writeDoors::ensureRemoved);
    }

    @Override
    public Collection<LoginBrokerInfo> doors() {
        this.expire();
        return this.unmodifiableView;
    }

    @Override
    public Map<String, Collection<LoginBrokerInfo>> readDoorsByProtocol() {
        this.expire();
        return this.readDoors.getUnmodifiable();
    }

    @Override
    public Map<String, Collection<LoginBrokerInfo>> writeDoorsByProtocol() {
        this.expire();
        return this.writeDoors.getUnmodifiable();
    }

    @Override
    public boolean anyMatch(Predicate<? super LoginBrokerInfo> predicate) {
        this.expire();
        return this.doorsByIdentity.values().stream().map(Entry::getLoginBrokerInfo).anyMatch(predicate);
    }

    private void expire() {
        Entry entry;
        while ((entry = (Entry)this.queue.poll()) != null) {
            this.remove(entry);
        }
    }

    private static class Entry
    implements Delayed {
        private final long expirationTime;
        private final LoginBrokerInfo info;

        public Entry(LoginBrokerInfo info) {
            this.expirationTime = System.currentTimeMillis() + (long)(2.5 * (double)info.getUpdateTime());
            this.info = info;
        }

        public LoginBrokerInfo getLoginBrokerInfo() {
            return this.info;
        }

        public boolean isValid() {
            return this.expirationTime > System.currentTimeMillis();
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(this.expirationTime - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(Delayed o) {
            return Long.compare(this.expirationTime, ((Entry)o).expirationTime);
        }
    }

    private static class ByProtocolMap {
        private final ConcurrentMap<String, Set<LoginBrokerInfo>> doors = new ConcurrentHashMap<String, Set<LoginBrokerInfo>>();
        private final Map<String, Collection<LoginBrokerInfo>> unmodifiableView = Collections.unmodifiableMap(Maps.transformValues((Map)Maps.filterValues(this.doors, set -> !set.isEmpty()), Collections::unmodifiableCollection));

        private ByProtocolMap() {
        }

        public void add(LoginBrokerInfo info) {
            this.get(info.getProtocolFamily()).add(info);
        }

        public boolean remove(LoginBrokerInfo info) {
            return this.get(info.getProtocolFamily()).remove(info);
        }

        public void ensureRemoved(LoginBrokerInfo info) {
            if (this.remove(info)) {
                LOGGER.warn("Removing phantom door {}", (Object)info);
            }
        }

        public Set<LoginBrokerInfo> get(String protocol) {
            return this.doors.computeIfAbsent(protocol, key -> Collections.newSetFromMap(new ConcurrentHashMap()));
        }

        public Map<String, Collection<LoginBrokerInfo>> getUnmodifiable() {
            return this.unmodifiableView;
        }
    }

    @Command(name="lb update", hint="refresh login broker information", description="Semi-blocking command to trigger an update of login brokering information for connected doors. The command blocks until the first reply is received or no doors could be found. Remaining updates are received in the background.")
    class UpdateCommand
    extends DelayedReply
    implements Callable<DelayedReply> {
        UpdateCommand() {
        }

        @Override
        public DelayedReply call() {
            return this;
        }

        @Override
        public void deliver(CellEndpoint endpoint, CellMessage envelope) {
            super.deliver(endpoint, envelope);
            LoginBrokerSubscriber.this.cellEndpoint.sendMessage(new CellMessage(LoginBrokerSubscriber.this.topic, (Serializable)new LoginBrokerInfoRequest()), new CellMessageAnswerable(){

                @Override
                public void answerArrived(CellMessage request, CellMessage answer) {
                    if (!(answer.getMessageObject() instanceof LoginBrokerInfo)) {
                        UpdateCommand.this.reply((Serializable)((Object)("Invalid reply received: " + answer.getMessageObject())));
                    } else {
                        LoginBrokerInfo info = (LoginBrokerInfo)answer.getMessageObject();
                        LoginBrokerSubscriber.this.add(new Entry(info));
                        UpdateCommand.this.reply((Serializable)((Object)("Update from " + info.getIdentifier() + " received. Remaining updates are processed in the background.")));
                    }
                }

                @Override
                public void exceptionArrived(CellMessage request, Exception exception) {
                    UpdateCommand.this.reply((Serializable)((Object)("Update failed: " + exception.getMessage())));
                }

                @Override
                public void answerTimedOut(CellMessage request) {
                    UpdateCommand.this.reply((Serializable)((Object)"Update timed out."));
                }
            }, MoreExecutors.directExecutor(), envelope.getAdjustedTtl(), new CellEndpoint.SendFlag[0]);
        }
    }

    @Command(name="lb ls", hint="list collected login broker information")
    class ListCommand
    implements Callable<String> {
        @Option(name="protocol", usage="Filter by protocol.")
        String[] protocols;
        @Option(name="l", usage="Show time.")
        boolean showTime;

        ListCommand() {
        }

        @Override
        public String call() {
            HashSet<String> protocolSet = this.protocols != null ? new HashSet<String>(Arrays.asList(this.protocols)) : null;
            StringBuilder sb = new StringBuilder();
            for (Entry entry : LoginBrokerSubscriber.this.doorsByIdentity.values()) {
                LoginBrokerInfo info = entry.getLoginBrokerInfo();
                if (protocolSet != null && !protocolSet.contains(info.getProtocolFamily())) continue;
                sb.append(info);
                if (this.showTime) {
                    sb.append(entry.getDelay(TimeUnit.MILLISECONDS)).append(" ms;");
                    sb.append(entry.isValid() ? "VALID" : "INVALID").append(';');
                }
                sb.append('\n');
            }
            return sb.toString();
        }
    }
}

