/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.services.login;

import com.google.common.collect.Ordering;
import dmg.cells.nucleus.CellEndpoint;
import dmg.cells.services.login.LoginCellFactory;
import dmg.cells.services.login.LoginCellProvider;
import java.util.ServiceLoader;
import org.dcache.util.Args;

public class LoginCellFactoryBuilder {
    private static final ServiceLoader<LoginCellProvider> PROVIDERS = ServiceLoader.load(LoginCellProvider.class);
    private String name;
    private Args args;
    private String loginManagerName;
    private CellEndpoint endpoint;

    public LoginCellFactoryBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public LoginCellFactoryBuilder setArgs(Args args) {
        this.args = args;
        return this;
    }

    public LoginCellFactoryBuilder setLoginManagerName(String loginManagerName) {
        this.loginManagerName = loginManagerName;
        return this;
    }

    public LoginCellFactoryBuilder setCellEndpoint(CellEndpoint endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public LoginCellFactory build() {
        LoginCellProvider bestProvider = (LoginCellProvider)Ordering.natural().onResultOf(p -> Integer.valueOf(p.getPriority(this.name))).max(PROVIDERS);
        if (bestProvider.getPriority(this.name) == Integer.MIN_VALUE) {
            throw new IllegalArgumentException("No login cell provider found for " + this.name);
        }
        return bestProvider.createFactory(this.name, this.args, this.endpoint, this.loginManagerName);
    }
}

