/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.services.login;

import com.google.common.util.concurrent.AbstractService;
import dmg.cells.nucleus.Cell;
import dmg.cells.nucleus.CellEndpoint;
import dmg.cells.services.login.LoginCellFactory;
import dmg.cells.services.login.LoginManager;
import dmg.cells.services.login.StreamEngineFactory;
import dmg.cells.services.login.TelnetSAuth_A;
import dmg.util.StreamEngine;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.Socket;
import javax.security.auth.Subject;
import org.dcache.auth.Subjects;
import org.dcache.util.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StreamEngineLoginCellFactory
extends AbstractService
implements LoginCellFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoginManager.class);
    private static final Class<?>[] AUTH_CON_SIGNATURE = new Class[]{CellEndpoint.class, Args.class};
    private final Args args;
    private final String protocol;
    private final Constructor<?> authConstructor;
    private final Class<?> authClass;
    private final CellEndpoint endpoint;

    public StreamEngineLoginCellFactory(Args args, CellEndpoint endpoint) {
        Constructor<?> authConstructor;
        this.args = args;
        this.endpoint = endpoint;
        this.protocol = StreamEngineLoginCellFactory.checkProtocol(args.getOpt("prot"));
        LOGGER.info("Using protocol : {}", (Object)this.protocol);
        try {
            this.authClass = StreamEngineLoginCellFactory.toAuthClass(args.getOpt("auth"), this.protocol);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("No such class: " + args.getOpt("auth"));
        }
        if (this.authClass != null) {
            try {
                authConstructor = this.authClass.getConstructor(AUTH_CON_SIGNATURE);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException("Class lacks authentication constructor: " + this.authClass);
            }
            LOGGER.trace("Using authentication constructor: {}", authConstructor);
        } else {
            authConstructor = null;
            LOGGER.trace("No authentication used");
        }
        this.authConstructor = authConstructor;
    }

    private static String checkProtocol(String protocol) throws IllegalArgumentException {
        if (protocol == null) {
            protocol = "telnet";
        }
        if (!protocol.equals("telnet") && !protocol.equals("raw")) {
            throw new IllegalArgumentException("Protocol must be telnet or raw");
        }
        return protocol;
    }

    private static Class<?> toAuthClass(String authClassName, String protocol) throws ClassNotFoundException {
        Class<Object> authClass = null;
        if (authClassName == null) {
            switch (protocol) {
                case "raw": {
                    authClass = null;
                    break;
                }
                case "telnet": {
                    authClass = TelnetSAuth_A.class;
                }
            }
        } else if (!authClassName.equals("none")) {
            authClass = Class.forName(authClassName);
        }
        if (authClass != null) {
            LOGGER.info("Using authentication Module: {}", authClass);
        }
        return authClass;
    }

    @Override
    public Cell newCell(Socket socket) throws InvocationTargetException {
        StreamEngine engine;
        try {
            engine = this.authConstructor != null ? StreamEngineFactory.newStreamEngine(socket, this.protocol, this.endpoint, this.args) : StreamEngineFactory.newStreamEngineWithoutAuth(socket, this.protocol);
        }
        catch (Exception e) {
            throw new InvocationTargetException(e, "Failed to instantiate stream engine: " + e);
        }
        String userName = Subjects.getDisplayName((Subject)engine.getSubject());
        LOGGER.info("connection created for user {}", (Object)userName);
        int p = userName.indexOf(64);
        if (p > -1) {
            userName = p == 0 ? "unknown" : userName.substring(0, p);
        }
        return this.newCell(engine, userName);
    }

    @Override
    public void getInfo(PrintWriter pw) {
        pw.println("  Factory        : " + this.getClass());
        pw.println("  Encoding       : " + this.protocol);
        if (this.authClass != null) {
            pw.println("  Authentication : " + this.authClass);
        }
    }

    public abstract Cell newCell(StreamEngine var1, String var2) throws InvocationTargetException;
}

