/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.services.login;

import com.google.common.base.Throwables;
import com.google.common.util.concurrent.MoreExecutors;
import dmg.cells.nucleus.CellEndpoint;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellPath;
import dmg.cells.nucleus.FutureCellMessageAnswerable;
import dmg.cells.services.login.UnixPassword;
import dmg.protocols.telnet.TelnetServerAuthentication;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.concurrent.ExecutionException;
import org.dcache.util.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TelnetSAuth_A
implements TelnetServerAuthentication {
    private static final Logger _log = LoggerFactory.getLogger(TelnetSAuth_A.class);
    private CellEndpoint _endpoint;
    private Args _args;
    private String _password;
    private boolean _localOk;
    private String _acmCell;
    private static UnixPassword __passwordFile;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TelnetSAuth_A(CellEndpoint endpoint, Args args) throws Exception {
        this._endpoint = endpoint;
        this._args = args;
        this._password = args.getOpt("passwd");
        this._password = this._password == null ? "elch" : this._password;
        this._localOk = args.hasOption("localOk");
        this._acmCell = args.getOpt("acm");
        String pwdFile = args.getOpt("pswdfile");
        Class<TelnetSAuth_A> clazz = TelnetSAuth_A.class;
        synchronized (TelnetSAuth_A.class) {
            if (__passwordFile == null && pwdFile != null) {
                __passwordFile = new UnixPassword(pwdFile);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    @Override
    public boolean isHostOk(InetAddress host) {
        return this._localOk;
    }

    @Override
    public boolean isUserOk(InetAddress host, String user) {
        return false;
    }

    private Object askAcm(Object ... request) throws Exception {
        CellMessage answerMsg;
        FutureCellMessageAnswerable reply = new FutureCellMessageAnswerable();
        this._endpoint.sendMessage(new CellMessage(new CellPath(this._acmCell), (Serializable)request), reply, MoreExecutors.directExecutor(), 4000L, new CellEndpoint.SendFlag[0]);
        try {
            answerMsg = (CellMessage)reply.get();
        }
        catch (ExecutionException e) {
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), Exception.class);
            Throwables.throwIfUnchecked((Throwable)e.getCause());
            throw new RuntimeException(e.getCause());
        }
        Serializable answer = answerMsg.getMessageObject();
        if (answer instanceof Exception) {
            throw (Exception)answer;
        }
        return answer;
    }

    private boolean checkPasswd(String user, String passwd) throws Exception {
        Object answer = this.askAcm("request", "*", "check-password", user, passwd);
        if (!(answer instanceof Object[]) || ((Object[])answer).length < 6 || !(((Object[])answer)[5] instanceof Boolean)) {
            throw new Exception("Wrong formated answer");
        }
        return (Boolean)((Object[])answer)[5];
    }

    private boolean checkAcl(String user, String action, String className, String instanceName) throws Exception {
        Object answer = this.askAcm("request", "*", "check-acl", user, action, className, instanceName);
        if (!(answer instanceof Object[]) || ((Object[])answer).length < 8 || !(((Object[])answer)[7] instanceof Boolean)) {
            throw new Exception("Wrong formated answer");
        }
        return (Boolean)((Object[])answer)[7];
    }

    @Override
    public boolean isPasswordOk(InetAddress host, String user, String passwd) {
        if (this._acmCell != null) {
            try {
                if (!this.checkPasswd(user, passwd)) {
                    throw new Exception("Not authenticated");
                }
                if (!this.checkAcl(user, "exec", "shell", "*")) {
                    throw new Exception("Not authorized");
                }
                return true;
            }
            catch (Exception e) {
                _log.info("Exception in TelnetSAuth_A : {}", (Object)e.toString());
                return false;
            }
        }
        if (__passwordFile != null) {
            return __passwordFile.checkPassword(user, passwd);
        }
        return passwd.equals(this._password);
    }
}

