/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.services.login;

import dmg.cells.services.login.Crypt;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class UnixPassword {
    private Hashtable<String, String> _hash;
    private Crypt _crypt = new Crypt();
    private long _timeStamp;
    private File _file;

    public UnixPassword(String pswFile) throws IOException {
        this._file = new File(pswFile);
        if (!this._file.canRead()) {
            throw new IOException("File Not Found : " + pswFile);
        }
        this._update();
    }

    public synchronized void update() {
        long ts = this._file.lastModified();
        try {
            if (ts > this._timeStamp) {
                this._update();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private synchronized void _update() throws IOException {
        this._hash = new Hashtable();
        try (InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(this._file), StandardCharsets.UTF_8);
             BufferedReader br = new BufferedReader(isr);){
            String line;
            while ((line = br.readLine()) != null) {
                try {
                    StringTokenizer st = new StringTokenizer(line, ":");
                    this._hash.put(st.nextToken(), st.nextToken());
                }
                catch (Exception exception) {}
            }
        }
    }

    public synchronized boolean checkPassword(String user, String password) {
        this.update();
        String cipher = this._hash.get(user);
        if (cipher == null) {
            return false;
        }
        String result = this._crypt.crypt(cipher, password);
        return this._crypt.crypt(cipher, password).equals(cipher);
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 3) {
            System.out.println("Usage : ... <file> <user> <passwd>");
            System.exit(4);
        }
        UnixPassword p = new UnixPassword(args[0]);
        System.out.println("Result : " + p.checkPassword(args[1], args[2]));
    }
}

