/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.services.login;

import dmg.util.Formats;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;

public class UserPrivileges {
    private Hashtable<String, String> _allowed = new Hashtable();
    private Hashtable<String, String> _denied = new Hashtable();
    private String _userName = "unknown";
    private boolean _faked;

    UserPrivileges() {
    }

    UserPrivileges(String userName) {
        this._userName = userName;
        this._faked = true;
    }

    UserPrivileges(String userName, String[] allowedList, String[] deniedList) {
        this._userName = userName;
        for (String s : allowedList) {
            this._allowed.put(s, s);
        }
        for (String s : deniedList) {
            this._denied.put(s, s);
            this._allowed.remove(s);
        }
    }

    public String getUserName() {
        return this._userName;
    }

    void mergeHorizontal(UserPrivileges right) {
        String attr;
        String o;
        Iterator<String> iterator = right._denied.keySet().iterator();
        while (iterator.hasNext()) {
            attr = o = iterator.next();
            this._denied.put(attr, attr);
        }
        iterator = right._allowed.keySet().iterator();
        while (iterator.hasNext()) {
            attr = o = iterator.next();
            this._allowed.put(attr, attr);
            this._denied.remove(attr);
        }
    }

    void mergeVertical(UserPrivileges upper) {
        String attr;
        for (String o : upper._allowed.keySet()) {
            attr = o;
            if (this._denied.get(attr) != null) continue;
            this._allowed.put(attr, attr);
        }
        for (String o : upper._denied.keySet()) {
            attr = o;
            if (this._allowed.get(attr) != null) continue;
            this._denied.put(attr, attr);
        }
    }

    public boolean isAllowed(String check) {
        if (this._faked) {
            return false;
        }
        if (this._userName.equals("root")) {
            return true;
        }
        try {
            int i;
            Object base;
            if (this._denied.get(check) != null) {
                return false;
            }
            if (this._allowed.get(check) != null) {
                return true;
            }
            int last = check.lastIndexOf(58);
            if (last < 0) {
                base = "";
            } else {
                base = check.substring(0, last) + ":";
                check = check.substring(last + 1);
            }
            if (check.length() < 1) {
                return false;
            }
            StringTokenizer st = new StringTokenizer(check, ".");
            String[] tokens = new String[st.countTokens()];
            for (i = 0; i < tokens.length; ++i) {
                tokens[i] = st.nextToken();
            }
            for (i = tokens.length; i > 0; --i) {
                StringBuilder sb = new StringBuilder();
                sb.append((String)base);
                for (int j = 0; j < i - 1; ++j) {
                    sb.append(tokens[j]).append('.');
                }
                sb.append('*');
                String x = sb.toString();
                if (this._denied.get(x) != null) {
                    return false;
                }
                if (this._allowed.get(x) == null) continue;
                return true;
            }
            return false;
        }
        catch (Exception ee) {
            ee.printStackTrace();
            return false;
        }
    }

    public String toString() {
        if (this._faked) {
            return "UserPrivileges for " + this._userName + " faked";
        }
        StringBuilder sb = new StringBuilder();
        String x = "         ";
        int dx = 20;
        int m = Math.min(this._allowed.size(), this._denied.size());
        Iterator<String> a = this._allowed.keySet().iterator();
        Iterator<String> d = this._denied.keySet().iterator();
        for (int i = 0; i < m; ++i) {
            sb.append(x).append(Formats.field(a.next(), dx)).append(Formats.field(d.next(), dx)).append('\n');
        }
        if (this._allowed.size() > m) {
            while (a.hasNext()) {
                sb.append(x).append(Formats.field(a.next(), dx)).append(Formats.field("", 20)).append('\n');
            }
        }
        if (this._denied.size() > m) {
            while (d.hasNext()) {
                sb.append(x).append(Formats.field("", 20)).append(Formats.field(d.next(), dx)).append('\n');
            }
        }
        return sb.toString();
    }
}

