/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.zookeeper;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import dmg.cells.nucleus.CDC;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.curator.CuratorZookeeperClient;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.WatcherRemoveCuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.ACLCreateModeBackgroundPathAndBytesable;
import org.apache.curator.framework.api.ACLCreateModePathAndBytesable;
import org.apache.curator.framework.api.ACLCreateModeStatBackgroundPathAndBytesable;
import org.apache.curator.framework.api.ACLPathAndBytesable;
import org.apache.curator.framework.api.ACLable;
import org.apache.curator.framework.api.ACLableExistBuilderMain;
import org.apache.curator.framework.api.BackgroundCallback;
import org.apache.curator.framework.api.BackgroundPathAndBytesable;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.curator.framework.api.BackgroundVersionable;
import org.apache.curator.framework.api.ChildrenDeletable;
import org.apache.curator.framework.api.CreateBackgroundModeACLable;
import org.apache.curator.framework.api.CreateBackgroundModeStatACLable;
import org.apache.curator.framework.api.CreateBuilder;
import org.apache.curator.framework.api.CreateBuilder2;
import org.apache.curator.framework.api.CreateBuilderMain;
import org.apache.curator.framework.api.CreateProtectACLCreateModePathAndBytesable;
import org.apache.curator.framework.api.CuratorListener;
import org.apache.curator.framework.api.CuratorWatcher;
import org.apache.curator.framework.api.DeleteBuilder;
import org.apache.curator.framework.api.DeleteBuilderMain;
import org.apache.curator.framework.api.ErrorListenerPathAndBytesable;
import org.apache.curator.framework.api.ErrorListenerPathable;
import org.apache.curator.framework.api.ExistsBuilder;
import org.apache.curator.framework.api.ExistsBuilderMain;
import org.apache.curator.framework.api.GetACLBuilder;
import org.apache.curator.framework.api.GetChildrenBuilder;
import org.apache.curator.framework.api.GetConfigBuilder;
import org.apache.curator.framework.api.GetDataBuilder;
import org.apache.curator.framework.api.GetDataWatchBackgroundStatable;
import org.apache.curator.framework.api.PathAndBytesable;
import org.apache.curator.framework.api.Pathable;
import org.apache.curator.framework.api.ProtectACLCreateModeStatPathAndBytesable;
import org.apache.curator.framework.api.ReconfigBuilder;
import org.apache.curator.framework.api.RemoveWatchesBuilder;
import org.apache.curator.framework.api.SetACLBuilder;
import org.apache.curator.framework.api.SetDataBackgroundVersionable;
import org.apache.curator.framework.api.SetDataBuilder;
import org.apache.curator.framework.api.SyncBuilder;
import org.apache.curator.framework.api.UnhandledErrorListener;
import org.apache.curator.framework.api.VersionPathAndBytesable;
import org.apache.curator.framework.api.WatchPathable;
import org.apache.curator.framework.api.transaction.CuratorMultiTransaction;
import org.apache.curator.framework.api.transaction.CuratorTransaction;
import org.apache.curator.framework.api.transaction.CuratorTransactionBridge;
import org.apache.curator.framework.api.transaction.CuratorTransactionFinal;
import org.apache.curator.framework.api.transaction.CuratorTransactionResult;
import org.apache.curator.framework.api.transaction.TransactionCheckBuilder;
import org.apache.curator.framework.api.transaction.TransactionCreateBuilder;
import org.apache.curator.framework.api.transaction.TransactionCreateBuilder2;
import org.apache.curator.framework.api.transaction.TransactionDeleteBuilder;
import org.apache.curator.framework.api.transaction.TransactionOp;
import org.apache.curator.framework.api.transaction.TransactionSetDataBuilder;
import org.apache.curator.framework.imps.CuratorFrameworkState;
import org.apache.curator.framework.listen.Listenable;
import org.apache.curator.framework.schema.SchemaSet;
import org.apache.curator.framework.state.ConnectionStateErrorPolicy;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.curator.utils.EnsurePath;
import org.apache.curator.utils.ThreadUtils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.server.quorum.flexible.QuorumVerifier;
import org.dcache.util.BoundedExecutor;
import org.dcache.util.SequentialExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CellCuratorFramework
implements CuratorFramework {
    private static final Logger LOGGER = LoggerFactory.getLogger(CellCuratorFramework.class);
    private final CuratorFramework inner;
    private final BoundedExecutor executor;
    private final LoadingCache<Watcher, Watcher> watchers = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Watcher, Watcher>(){

        public Watcher load(Watcher watcher) throws Exception {
            CDC cdc = new CDC();
            return event -> CellCuratorFramework.this.executor.execute(() -> {
                try (CDC ignore = cdc.restore();){
                    watcher.process(event);
                }
            });
        }
    });
    private final LoadingCache<CuratorWatcher, CuratorWatcher> curatorWatchers = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<CuratorWatcher, CuratorWatcher>(){

        public CuratorWatcher load(CuratorWatcher watcher) throws Exception {
            CDC cdc = new CDC();
            return event -> CellCuratorFramework.this.executor.execute(() -> {
                try (CDC ignore = cdc.restore();){
                    try {
                        watcher.process(event);
                    }
                    catch (Exception e) {
                        ThreadUtils.checkInterrupted((Throwable)e);
                        LOGGER.error("Watcher exception", (Throwable)e);
                    }
                }
            });
        }
    });

    public CellCuratorFramework(CuratorFramework inner, Executor executor) {
        this.inner = inner;
        this.executor = new SequentialExecutor(executor){

            public void execute(Runnable task) {
                block2: {
                    try {
                        super.execute(task);
                    }
                    catch (RejectedExecutionException e) {
                        if (this.isShutdown()) break block2;
                        throw e;
                    }
                }
            }
        };
    }

    protected static BackgroundCallback wrap(BackgroundCallback callback) {
        CDC cdc = new CDC();
        return (client, event) -> {
            try (CDC ignore = cdc.restore();){
                callback.processResult(client, event);
            }
        };
    }

    protected Watcher wrap(Watcher watcher) {
        return (Watcher)this.watchers.getUnchecked((Object)watcher);
    }

    protected CuratorWatcher wrap(CuratorWatcher watcher) {
        return (CuratorWatcher)this.curatorWatchers.getUnchecked((Object)watcher);
    }

    public void start() {
        throw new RuntimeException();
    }

    public void close() {
        throw new RuntimeException();
    }

    public CuratorFrameworkState getState() {
        return this.inner.getState();
    }

    @Deprecated
    public boolean isStarted() {
        return this.inner.isStarted();
    }

    public CreateBuilder create() {
        return new CreateBuilderDecorator(this.inner.create());
    }

    public DeleteBuilder delete() {
        return new DeleteBuilderDecorator(this.inner.delete());
    }

    public ExistsBuilder checkExists() {
        return new ExistsBuilderDecorator(this.inner.checkExists());
    }

    public GetDataBuilder getData() {
        return new GetDataBuilderDecorator(this.inner.getData());
    }

    public SetDataBuilder setData() {
        return new SetDataBuilderDecorator(this.inner.setData());
    }

    public GetChildrenBuilder getChildren() {
        return new GetChildrenBuilderDecorator(this.inner.getChildren());
    }

    public GetACLBuilder getACL() {
        return new GetACLBuilderDecorator(this.inner.getACL());
    }

    public SetACLBuilder setACL() {
        return new SetACLBuilderDecorator(this.inner.setACL());
    }

    public ReconfigBuilder reconfig() {
        return this.inner.reconfig();
    }

    public GetConfigBuilder getConfig() {
        return this.inner.getConfig();
    }

    public CuratorTransaction inTransaction() {
        return new CuratorTransactionDecorator(this.inner.inTransaction());
    }

    public CuratorMultiTransaction transaction() {
        return this.inner.transaction();
    }

    public TransactionOp transactionOp() {
        return this.inner.transactionOp();
    }

    @Deprecated
    public void sync(String path, Object backgroundContextObject) {
        this.inner.sync(path, backgroundContextObject);
    }

    public void createContainers(String path) throws Exception {
        this.inner.createContainers(path);
    }

    public SyncBuilder sync() {
        return new SyncBuilderDecorator(this.inner.sync());
    }

    public RemoveWatchesBuilder watches() {
        return this.inner.watches();
    }

    public Listenable<ConnectionStateListener> getConnectionStateListenable() {
        return new ListenableDecorator<ConnectionStateListener>(this.inner.getConnectionStateListenable(), (Executor)this.executor);
    }

    public Listenable<CuratorListener> getCuratorListenable() {
        return new ListenableDecorator<CuratorListener>(this.inner.getCuratorListenable(), (Executor)this.executor);
    }

    public Listenable<UnhandledErrorListener> getUnhandledErrorListenable() {
        return new ListenableDecorator<UnhandledErrorListener>(this.inner.getUnhandledErrorListenable(), (Executor)this.executor);
    }

    @Deprecated
    public CuratorFramework nonNamespaceView() {
        return new CellCuratorFramework(this.inner.nonNamespaceView(), (Executor)this.executor);
    }

    public CuratorFramework usingNamespace(String newNamespace) {
        return new CellCuratorFramework(this.inner.usingNamespace(newNamespace), (Executor)this.executor);
    }

    public String getNamespace() {
        return this.inner.getNamespace();
    }

    public CuratorZookeeperClient getZookeeperClient() {
        return this.inner.getZookeeperClient();
    }

    @Deprecated
    public EnsurePath newNamespaceAwareEnsurePath(String path) {
        return this.inner.newNamespaceAwareEnsurePath(path);
    }

    public void clearWatcherReferences(Watcher watcher) {
        Watcher wrapped = (Watcher)this.watchers.getIfPresent((Object)watcher);
        if (wrapped != null) {
            this.inner.clearWatcherReferences(wrapped);
        }
    }

    public boolean blockUntilConnected(int maxWaitTime, TimeUnit units) throws InterruptedException {
        return this.inner.blockUntilConnected(maxWaitTime, units);
    }

    public void blockUntilConnected() throws InterruptedException {
        this.inner.blockUntilConnected();
    }

    public WatcherRemoveCuratorFramework newWatcherRemoveCuratorFramework() {
        return this.inner.newWatcherRemoveCuratorFramework();
    }

    public ConnectionStateErrorPolicy getConnectionStateErrorPolicy() {
        return this.inner.getConnectionStateErrorPolicy();
    }

    public QuorumVerifier getCurrentConfig() {
        return this.inner.getCurrentConfig();
    }

    public SchemaSet getSchemaSet() {
        return this.inner.getSchemaSet();
    }

    public boolean isZk34CompatibilityMode() {
        return this.inner.isZk34CompatibilityMode();
    }

    public CompletableFuture<Void> runSafe(Runnable runnable) {
        return CompletableFuture.runAsync(runnable, (Executor)this.executor);
    }

    private class VersionPathAndBytesableCuratorTransactionBridgeDecorator
    implements VersionPathAndBytesable<CuratorTransactionBridge> {
        private final VersionPathAndBytesable<CuratorTransactionBridge> inner;

        public VersionPathAndBytesableCuratorTransactionBridgeDecorator(VersionPathAndBytesable<CuratorTransactionBridge> inner) {
            this.inner = inner;
        }

        public CuratorTransactionBridge forPath(String s, byte[] bytes) throws Exception {
            return new CuratorTransactionBridgeDecorator((CuratorTransactionBridge)this.inner.forPath(s, bytes));
        }

        public CuratorTransactionBridge forPath(String s) throws Exception {
            return new CuratorTransactionBridgeDecorator((CuratorTransactionBridge)this.inner.forPath(s));
        }

        public PathAndBytesable<CuratorTransactionBridge> withVersion(int i) {
            return new PathAndBytesableDecorator<CuratorTransactionBridge>((PathAndBytesable)this.inner.withVersion(i));
        }
    }

    private class ACLableBackgroundPathableDecorator<T>
    implements ACLable<BackgroundPathable<T>> {
        private final ACLable<BackgroundPathable<T>> inner;

        public ACLableBackgroundPathableDecorator(ACLable<BackgroundPathable<T>> inner) {
            this.inner = inner;
        }

        public BackgroundPathable<T> withACL(List<ACL> aclList) {
            return new BackgroundPathableDecorator((BackgroundPathable)this.inner.withACL(aclList));
        }
    }

    private class SetDataBackgroundVersionableDecorator
    implements SetDataBackgroundVersionable {
        private final SetDataBackgroundVersionable inner;

        public SetDataBackgroundVersionableDecorator(SetDataBackgroundVersionable inner) {
            this.inner = inner;
        }

        public ErrorListenerPathAndBytesable<Stat> inBackground() {
            return new ErrorListenerPathAndBytesableDecorator<Stat>((ErrorListenerPathAndBytesable)this.inner.inBackground());
        }

        public ErrorListenerPathAndBytesable<Stat> inBackground(Object context) {
            return new ErrorListenerPathAndBytesableDecorator<Stat>((ErrorListenerPathAndBytesable)this.inner.inBackground(context));
        }

        public ErrorListenerPathAndBytesable<Stat> inBackground(BackgroundCallback callback) {
            return new ErrorListenerPathAndBytesableDecorator<Stat>((ErrorListenerPathAndBytesable)this.inner.inBackground(CellCuratorFramework.wrap(callback), (Executor)CellCuratorFramework.this.executor));
        }

        public ErrorListenerPathAndBytesable<Stat> inBackground(BackgroundCallback callback, Object context) {
            return new ErrorListenerPathAndBytesableDecorator<Stat>((ErrorListenerPathAndBytesable)this.inner.inBackground(CellCuratorFramework.wrap(callback), context, (Executor)CellCuratorFramework.this.executor));
        }

        public ErrorListenerPathAndBytesable<Stat> inBackground(BackgroundCallback callback, Executor executor) {
            return new ErrorListenerPathAndBytesableDecorator<Stat>((ErrorListenerPathAndBytesable)this.inner.inBackground(CellCuratorFramework.wrap(callback), executor));
        }

        public ErrorListenerPathAndBytesable<Stat> inBackground(BackgroundCallback callback, Object context, Executor executor) {
            return new ErrorListenerPathAndBytesableDecorator<Stat>((ErrorListenerPathAndBytesable)this.inner.inBackground(CellCuratorFramework.wrap(callback), context, executor));
        }

        public Stat forPath(String path, byte[] data) throws Exception {
            return (Stat)this.inner.forPath(path, data);
        }

        public Stat forPath(String path) throws Exception {
            return (Stat)this.inner.forPath(path);
        }

        public BackgroundPathAndBytesable<Stat> withVersion(int version) {
            return new BackgroundPathAndBytesableDecorator<Stat>((BackgroundPathAndBytesable)this.inner.withVersion(version));
        }
    }

    private class WatchPathableDecorator<T>
    implements WatchPathable<T> {
        private final WatchPathable<T> inner;

        public WatchPathableDecorator(WatchPathable<T> inner) {
            this.inner = inner;
        }

        public T forPath(String path) throws Exception {
            return (T)this.inner.forPath(path);
        }

        public Pathable<T> watched() {
            return new PathableDecorator((Pathable)this.inner.watched());
        }

        public Pathable<T> usingWatcher(Watcher watcher) {
            return new PathableDecorator((Pathable)this.inner.usingWatcher(CellCuratorFramework.this.wrap(watcher)));
        }

        public Pathable<T> usingWatcher(CuratorWatcher watcher) {
            return new PathableDecorator((Pathable)this.inner.usingWatcher(CellCuratorFramework.this.wrap(watcher)));
        }
    }

    private class GetDataWatchBackgroundStatableDecorator
    implements GetDataWatchBackgroundStatable {
        private final GetDataWatchBackgroundStatable inner;

        public GetDataWatchBackgroundStatableDecorator(GetDataWatchBackgroundStatable inner) {
            this.inner = inner;
        }

        public ErrorListenerPathable<byte[]> inBackground() {
            return new ErrorListenerPathableDecorator<byte[]>((ErrorListenerPathable)this.inner.inBackground());
        }

        public ErrorListenerPathable<byte[]> inBackground(Object context) {
            return new ErrorListenerPathableDecorator<byte[]>((ErrorListenerPathable)this.inner.inBackground(context));
        }

        public ErrorListenerPathable<byte[]> inBackground(BackgroundCallback callback) {
            return new ErrorListenerPathableDecorator<byte[]>((ErrorListenerPathable)this.inner.inBackground(CellCuratorFramework.wrap(callback), (Executor)CellCuratorFramework.this.executor));
        }

        public ErrorListenerPathable<byte[]> inBackground(BackgroundCallback callback, Object context) {
            return new ErrorListenerPathableDecorator<byte[]>((ErrorListenerPathable)this.inner.inBackground(CellCuratorFramework.wrap(callback), context, (Executor)CellCuratorFramework.this.executor));
        }

        public ErrorListenerPathable<byte[]> inBackground(BackgroundCallback callback, Executor executor) {
            return new ErrorListenerPathableDecorator<byte[]>((ErrorListenerPathable)this.inner.inBackground(CellCuratorFramework.wrap(callback), executor));
        }

        public ErrorListenerPathable<byte[]> inBackground(BackgroundCallback callback, Object context, Executor executor) {
            return new ErrorListenerPathableDecorator<byte[]>((ErrorListenerPathable)this.inner.inBackground(CellCuratorFramework.wrap(callback), context, executor));
        }

        public byte[] forPath(String path) throws Exception {
            return (byte[])this.inner.forPath(path);
        }

        public WatchPathable<byte[]> storingStatIn(Stat stat) {
            return new WatchPathableDecorator<byte[]>((WatchPathable)this.inner.storingStatIn(stat));
        }

        public BackgroundPathable<byte[]> watched() {
            return new BackgroundPathableDecorator<byte[]>((BackgroundPathable)this.inner.watched());
        }

        public BackgroundPathable<byte[]> usingWatcher(Watcher watcher) {
            return new BackgroundPathableDecorator<byte[]>((BackgroundPathable)this.inner.usingWatcher(CellCuratorFramework.this.wrap(watcher)));
        }

        public BackgroundPathable<byte[]> usingWatcher(CuratorWatcher watcher) {
            return new BackgroundPathableDecorator<byte[]>((BackgroundPathable)this.inner.usingWatcher(CellCuratorFramework.this.wrap(watcher)));
        }
    }

    private class BackgroundPathableDecorator<T>
    implements BackgroundPathable<T> {
        private final BackgroundPathable<T> inner;

        public BackgroundPathableDecorator(BackgroundPathable<T> inner) {
            this.inner = inner;
        }

        public ErrorListenerPathable<T> inBackground() {
            return new ErrorListenerPathableDecorator((ErrorListenerPathable)this.inner.inBackground());
        }

        public ErrorListenerPathable<T> inBackground(Object context) {
            return new ErrorListenerPathableDecorator((ErrorListenerPathable)this.inner.inBackground(context));
        }

        public ErrorListenerPathable<T> inBackground(BackgroundCallback callback) {
            return new ErrorListenerPathableDecorator((ErrorListenerPathable)this.inner.inBackground(CellCuratorFramework.wrap(callback), (Executor)CellCuratorFramework.this.executor));
        }

        public ErrorListenerPathable<T> inBackground(BackgroundCallback callback, Object context) {
            return new ErrorListenerPathableDecorator((ErrorListenerPathable)this.inner.inBackground(CellCuratorFramework.wrap(callback), context, (Executor)CellCuratorFramework.this.executor));
        }

        public ErrorListenerPathable<T> inBackground(BackgroundCallback callback, Executor executor) {
            return new ErrorListenerPathableDecorator((ErrorListenerPathable)this.inner.inBackground(CellCuratorFramework.wrap(callback), executor));
        }

        public ErrorListenerPathable<T> inBackground(BackgroundCallback callback, Object context, Executor executor) {
            return new ErrorListenerPathableDecorator((ErrorListenerPathable)this.inner.inBackground(CellCuratorFramework.wrap(callback), context, executor));
        }

        public T forPath(String path) throws Exception {
            return (T)this.inner.forPath(path);
        }
    }

    private class PathableCuratorTransactionBridgeDecorator
    implements Pathable<CuratorTransactionBridge> {
        private final Pathable<CuratorTransactionBridge> inner;

        public PathableCuratorTransactionBridgeDecorator(Pathable<CuratorTransactionBridge> inner) {
            this.inner = inner;
        }

        public CuratorTransactionBridge forPath(String path) throws Exception {
            return new CuratorTransactionBridgeDecorator((CuratorTransactionBridge)this.inner.forPath(path));
        }
    }

    private static class ErrorListenerPathableDecorator<T>
    implements ErrorListenerPathable<T> {
        private final ErrorListenerPathable<T> inner;

        public ErrorListenerPathableDecorator(ErrorListenerPathable<T> inner) {
            this.inner = inner;
        }

        public Pathable<T> withUnhandledErrorListener(UnhandledErrorListener unhandledErrorListener) {
            return new PathableDecorator(this.inner.withUnhandledErrorListener(unhandledErrorListener));
        }

        public T forPath(String path) throws Exception {
            return (T)this.inner.forPath(path);
        }
    }

    private static class PathableDecorator<T>
    implements Pathable<T> {
        private final Pathable<T> inner;

        public PathableDecorator(Pathable<T> inner) {
            this.inner = inner;
        }

        public T forPath(String path) throws Exception {
            return (T)this.inner.forPath(path);
        }
    }

    private class ChildrenDeletableDecorator
    implements ChildrenDeletable {
        private final ChildrenDeletable inner;

        private ChildrenDeletableDecorator(ChildrenDeletable inner) {
            this.inner = inner;
        }

        public BackgroundVersionable deletingChildrenIfNeeded() {
            return new BackgroundVersionableDecorator(this.inner.deletingChildrenIfNeeded());
        }

        public ErrorListenerPathable<Void> inBackground() {
            return new ErrorListenerPathableDecorator<Void>((ErrorListenerPathable)this.inner.inBackground());
        }

        public ErrorListenerPathable<Void> inBackground(Object context) {
            return new ErrorListenerPathableDecorator<Void>((ErrorListenerPathable)this.inner.inBackground(context));
        }

        public ErrorListenerPathable<Void> inBackground(BackgroundCallback callback) {
            return new ErrorListenerPathableDecorator<Void>((ErrorListenerPathable)this.inner.inBackground(CellCuratorFramework.wrap(callback), (Executor)CellCuratorFramework.this.executor));
        }

        public ErrorListenerPathable<Void> inBackground(BackgroundCallback callback, Object context) {
            return new ErrorListenerPathableDecorator<Void>((ErrorListenerPathable)this.inner.inBackground(CellCuratorFramework.wrap(callback), context, (Executor)CellCuratorFramework.this.executor));
        }

        public ErrorListenerPathable<Void> inBackground(BackgroundCallback callback, Executor executor) {
            return new ErrorListenerPathableDecorator<Void>((ErrorListenerPathable)this.inner.inBackground(CellCuratorFramework.wrap(callback), executor));
        }

        public ErrorListenerPathable<Void> inBackground(BackgroundCallback callback, Object context, Executor executor) {
            return new ErrorListenerPathableDecorator<Void>((ErrorListenerPathable)this.inner.inBackground(CellCuratorFramework.wrap(callback), context, executor));
        }

        public Void forPath(String path) throws Exception {
            return (Void)this.inner.forPath(path);
        }

        public BackgroundPathable<Void> withVersion(int version) {
            return (BackgroundPathable)this.inner.withVersion(version);
        }
    }

    private class BackgroundVersionableDecorator
    implements BackgroundVersionable {
        private final BackgroundVersionable inner;

        private BackgroundVersionableDecorator(BackgroundVersionable inner) {
            this.inner = inner;
        }

        public ErrorListenerPathable<Void> inBackground() {
            return new ErrorListenerPathableDecorator<Void>((ErrorListenerPathable)this.inner.inBackground());
        }

        public ErrorListenerPathable<Void> inBackground(Object context) {
            return new ErrorListenerPathableDecorator<Void>((ErrorListenerPathable)this.inner.inBackground(context));
        }

        public ErrorListenerPathable<Void> inBackground(BackgroundCallback callback) {
            return new ErrorListenerPathableDecorator<Void>((ErrorListenerPathable)this.inner.inBackground(CellCuratorFramework.wrap(callback), (Executor)CellCuratorFramework.this.executor));
        }

        public ErrorListenerPathable<Void> inBackground(BackgroundCallback callback, Object context) {
            return new ErrorListenerPathableDecorator<Void>((ErrorListenerPathable)this.inner.inBackground(CellCuratorFramework.wrap(callback), context, (Executor)CellCuratorFramework.this.executor));
        }

        public ErrorListenerPathable<Void> inBackground(BackgroundCallback callback, Executor executor) {
            return new ErrorListenerPathableDecorator<Void>((ErrorListenerPathable)this.inner.inBackground(CellCuratorFramework.wrap(callback), executor));
        }

        public ErrorListenerPathable<Void> inBackground(BackgroundCallback callback, Object context, Executor executor) {
            return new ErrorListenerPathableDecorator<Void>((ErrorListenerPathable)this.inner.inBackground(CellCuratorFramework.wrap(callback), context, executor));
        }

        public Void forPath(String path) throws Exception {
            return (Void)this.inner.forPath(path);
        }

        public BackgroundPathable<Void> withVersion(int version) {
            return (BackgroundPathable)this.inner.withVersion(version);
        }
    }

    private static class ACLCreateModePathAndBytesableDecorator<T>
    implements ACLCreateModePathAndBytesable<T> {
        private final ACLCreateModePathAndBytesable<T> inner;

        public ACLCreateModePathAndBytesableDecorator(ACLCreateModePathAndBytesable<T> inner) {
            this.inner = inner;
        }

        public PathAndBytesable<T> withACL(List<ACL> aclList) {
            return new PathAndBytesableDecorator((PathAndBytesable)this.inner.withACL(aclList));
        }

        public ACLPathAndBytesable<T> withMode(CreateMode mode) {
            return new ACLPathAndBytesableDecorator((ACLPathAndBytesable)this.inner.withMode(mode));
        }

        public T forPath(String path, byte[] data) throws Exception {
            return (T)this.inner.forPath(path, data);
        }

        public T forPath(String path) throws Exception {
            return (T)this.inner.forPath(path);
        }

        public PathAndBytesable<T> withACL(List<ACL> list, boolean b) {
            return new PathAndBytesableDecorator((PathAndBytesable)this.inner.withACL(list, b));
        }
    }

    private class ACLBackgroundPathAndBytesableDecorator<T>
    implements ACLBackgroundPathAndBytesable<T> {
        private final ACLBackgroundPathAndBytesable<T> inner;

        public ACLBackgroundPathAndBytesableDecorator(ACLBackgroundPathAndBytesable<T> inner) {
            this.inner = inner;
        }

        public BackgroundPathAndBytesable<T> withACL(List<ACL> aclList) {
            return new BackgroundPathAndBytesableDecorator((BackgroundPathAndBytesable)this.inner.withACL(aclList));
        }

        public ErrorListenerPathAndBytesable<T> inBackground() {
            return new ErrorListenerPathAndBytesableDecorator((ErrorListenerPathAndBytesable)this.inner.inBackground());
        }

        public ErrorListenerPathAndBytesable<T> inBackground(Object context) {
            return new ErrorListenerPathAndBytesableDecorator((ErrorListenerPathAndBytesable)this.inner.inBackground(context));
        }

        public ErrorListenerPathAndBytesable<T> inBackground(BackgroundCallback callback) {
            return new ErrorListenerPathAndBytesableDecorator((ErrorListenerPathAndBytesable)this.inner.inBackground(CellCuratorFramework.wrap(callback), (Executor)CellCuratorFramework.this.executor));
        }

        public ErrorListenerPathAndBytesable<T> inBackground(BackgroundCallback callback, Object context) {
            return new ErrorListenerPathAndBytesableDecorator((ErrorListenerPathAndBytesable)this.inner.inBackground(CellCuratorFramework.wrap(callback), context, (Executor)CellCuratorFramework.this.executor));
        }

        public ErrorListenerPathAndBytesable<T> inBackground(BackgroundCallback callback, Executor executor) {
            return new ErrorListenerPathAndBytesableDecorator((ErrorListenerPathAndBytesable)this.inner.inBackground(CellCuratorFramework.wrap(callback), executor));
        }

        public ErrorListenerPathAndBytesable<T> inBackground(BackgroundCallback callback, Object context, Executor executor) {
            return new ErrorListenerPathAndBytesableDecorator((ErrorListenerPathAndBytesable)this.inner.inBackground(CellCuratorFramework.wrap(callback), context, executor));
        }

        public T forPath(String path, byte[] data) throws Exception {
            return (T)this.inner.forPath(path, data);
        }

        public T forPath(String path) throws Exception {
            return (T)this.inner.forPath(path);
        }

        public BackgroundPathAndBytesable<T> withACL(List<ACL> list, boolean b) {
            return new BackgroundPathAndBytesableDecorator((BackgroundPathAndBytesable)this.inner.withACL(list, b));
        }
    }

    private class CreateBackgroundModeStatACLableDecorator
    implements CreateBackgroundModeStatACLable {
        private final CreateBackgroundModeStatACLable inner;

        public CreateBackgroundModeStatACLableDecorator(CreateBackgroundModeStatACLable inner) {
            this.inner = inner;
        }

        public ACLCreateModePathAndBytesable<String> creatingParentsIfNeeded() {
            return new ACLCreateModePathAndBytesableDecorator<String>(this.inner.creatingParentsIfNeeded());
        }

        public ACLCreateModePathAndBytesable<String> creatingParentContainersIfNeeded() {
            return new ACLCreateModePathAndBytesableDecorator<String>(this.inner.creatingParentContainersIfNeeded());
        }

        public ACLPathAndBytesable<String> withProtectedEphemeralSequential() {
            return new ACLPathAndBytesableDecorator<String>(this.inner.withProtectedEphemeralSequential());
        }

        public BackgroundPathAndBytesable<String> withACL(List<ACL> aclList) {
            return new BackgroundPathAndBytesableDecorator<String>((BackgroundPathAndBytesable)this.inner.withACL(aclList));
        }

        public ErrorListenerPathAndBytesable<String> inBackground() {
            return new ErrorListenerPathAndBytesableDecorator<String>((ErrorListenerPathAndBytesable)this.inner.inBackground());
        }

        public ErrorListenerPathAndBytesable<String> inBackground(Object context) {
            return new ErrorListenerPathAndBytesableDecorator<String>((ErrorListenerPathAndBytesable)this.inner.inBackground(context));
        }

        public ErrorListenerPathAndBytesable<String> inBackground(BackgroundCallback callback) {
            return new ErrorListenerPathAndBytesableDecorator<String>((ErrorListenerPathAndBytesable)this.inner.inBackground(CellCuratorFramework.wrap(callback), (Executor)CellCuratorFramework.this.executor));
        }

        public ErrorListenerPathAndBytesable<String> inBackground(BackgroundCallback callback, Object context) {
            return new ErrorListenerPathAndBytesableDecorator<String>((ErrorListenerPathAndBytesable)this.inner.inBackground(CellCuratorFramework.wrap(callback), context, (Executor)CellCuratorFramework.this.executor));
        }

        public ErrorListenerPathAndBytesable<String> inBackground(BackgroundCallback callback, Executor executor) {
            return new ErrorListenerPathAndBytesableDecorator<String>((ErrorListenerPathAndBytesable)this.inner.inBackground(CellCuratorFramework.wrap(callback), executor));
        }

        public ErrorListenerPathAndBytesable<String> inBackground(BackgroundCallback callback, Object context, Executor executor) {
            return new ErrorListenerPathAndBytesableDecorator<String>((ErrorListenerPathAndBytesable)this.inner.inBackground(CellCuratorFramework.wrap(callback), context, executor));
        }

        public ACLBackgroundPathAndBytesable<String> withMode(CreateMode mode) {
            return new ACLBackgroundPathAndBytesableDecorator<String>((ACLBackgroundPathAndBytesable)this.inner.withMode(mode));
        }

        public String forPath(String path, byte[] data) throws Exception {
            return (String)this.inner.forPath(path, data);
        }

        public String forPath(String path) throws Exception {
            return (String)this.inner.forPath(path);
        }

        public BackgroundPathAndBytesable<String> withACL(List<ACL> list, boolean b) {
            return new BackgroundPathAndBytesableDecorator<String>((BackgroundPathAndBytesable)this.inner.withACL(list, b));
        }

        public CreateBackgroundModeACLable storingStatIn(Stat stat) {
            return (CreateBackgroundModeACLable)this.inner.storingStatIn(stat);
        }
    }

    private class PathAndBytesableCuratorTransactionBridgeDecorator
    implements PathAndBytesable<CuratorTransactionBridge> {
        private final PathAndBytesable<CuratorTransactionBridge> inner;

        public PathAndBytesableCuratorTransactionBridgeDecorator(PathAndBytesable<CuratorTransactionBridge> inner) {
            this.inner = inner;
        }

        public CuratorTransactionBridge forPath(String path, byte[] data) throws Exception {
            return new CuratorTransactionBridgeDecorator((CuratorTransactionBridge)this.inner.forPath(path, data));
        }

        public CuratorTransactionBridge forPath(String path) throws Exception {
            return new CuratorTransactionBridgeDecorator((CuratorTransactionBridge)this.inner.forPath(path));
        }
    }

    private static class ErrorListenerPathAndBytesableDecorator<T>
    implements ErrorListenerPathAndBytesable<T> {
        private final ErrorListenerPathAndBytesable<T> inner;

        public ErrorListenerPathAndBytesableDecorator(ErrorListenerPathAndBytesable<T> inner) {
            this.inner = inner;
        }

        public PathAndBytesable<T> withUnhandledErrorListener(UnhandledErrorListener unhandledErrorListener) {
            return new PathAndBytesableDecorator(this.inner.withUnhandledErrorListener(unhandledErrorListener));
        }

        public T forPath(String path, byte[] data) throws Exception {
            return (T)this.inner.forPath(path, data);
        }

        public T forPath(String path) throws Exception {
            return (T)this.inner.forPath(path);
        }
    }

    private static class PathAndBytesableDecorator<T>
    implements PathAndBytesable<T> {
        private final PathAndBytesable<T> inner;

        public PathAndBytesableDecorator(PathAndBytesable<T> inner) {
            this.inner = inner;
        }

        public T forPath(String path, byte[] data) throws Exception {
            return (T)this.inner.forPath(path, data);
        }

        public T forPath(String path) throws Exception {
            return (T)this.inner.forPath(path);
        }
    }

    private class BackgroundPathAndBytesableDecorator<T>
    implements BackgroundPathAndBytesable<T> {
        private final BackgroundPathAndBytesable<T> inner;

        public BackgroundPathAndBytesableDecorator(BackgroundPathAndBytesable<T> inner) {
            this.inner = inner;
        }

        public ErrorListenerPathAndBytesable<T> inBackground() {
            return new ErrorListenerPathAndBytesableDecorator((ErrorListenerPathAndBytesable)this.inner.inBackground());
        }

        public ErrorListenerPathAndBytesable<T> inBackground(Object context) {
            return new ErrorListenerPathAndBytesableDecorator((ErrorListenerPathAndBytesable)this.inner.inBackground(context));
        }

        public ErrorListenerPathAndBytesable<T> inBackground(BackgroundCallback callback) {
            return new ErrorListenerPathAndBytesableDecorator((ErrorListenerPathAndBytesable)this.inner.inBackground(CellCuratorFramework.wrap(callback), (Executor)CellCuratorFramework.this.executor));
        }

        public ErrorListenerPathAndBytesable<T> inBackground(BackgroundCallback callback, Object context) {
            return new ErrorListenerPathAndBytesableDecorator((ErrorListenerPathAndBytesable)this.inner.inBackground(CellCuratorFramework.wrap(callback), context, (Executor)CellCuratorFramework.this.executor));
        }

        public ErrorListenerPathAndBytesable<T> inBackground(BackgroundCallback callback, Executor executor) {
            return new ErrorListenerPathAndBytesableDecorator((ErrorListenerPathAndBytesable)this.inner.inBackground(CellCuratorFramework.wrap(callback), executor));
        }

        public ErrorListenerPathAndBytesable<T> inBackground(BackgroundCallback callback, Object context, Executor executor) {
            return new ErrorListenerPathAndBytesableDecorator((ErrorListenerPathAndBytesable)this.inner.inBackground(CellCuratorFramework.wrap(callback), context, executor));
        }

        public T forPath(String path, byte[] data) throws Exception {
            return (T)this.inner.forPath(path, data);
        }

        public T forPath(String path) throws Exception {
            return (T)this.inner.forPath(path);
        }
    }

    private class ACLCreateModeStatBackgroundPathAndBytesableDecorator<T>
    implements ACLCreateModeStatBackgroundPathAndBytesable<T> {
        private final ACLCreateModeStatBackgroundPathAndBytesable<T> inner;

        public ACLCreateModeStatBackgroundPathAndBytesableDecorator(ACLCreateModeStatBackgroundPathAndBytesable<T> inner) {
            this.inner = inner;
        }

        public BackgroundPathAndBytesable<T> withACL(List<ACL> aclList) {
            return new BackgroundPathAndBytesableDecorator((BackgroundPathAndBytesable)this.inner.withACL(aclList));
        }

        public ErrorListenerPathAndBytesable<T> inBackground() {
            return new ErrorListenerPathAndBytesableDecorator((ErrorListenerPathAndBytesable)this.inner.inBackground());
        }

        public ErrorListenerPathAndBytesable<T> inBackground(Object context) {
            return new ErrorListenerPathAndBytesableDecorator((ErrorListenerPathAndBytesable)this.inner.inBackground(context));
        }

        public ErrorListenerPathAndBytesable<T> inBackground(BackgroundCallback callback) {
            return new ErrorListenerPathAndBytesableDecorator((ErrorListenerPathAndBytesable)this.inner.inBackground(CellCuratorFramework.wrap(callback), (Executor)CellCuratorFramework.this.executor));
        }

        public ErrorListenerPathAndBytesable<T> inBackground(BackgroundCallback callback, Object context) {
            return new ErrorListenerPathAndBytesableDecorator((ErrorListenerPathAndBytesable)this.inner.inBackground(CellCuratorFramework.wrap(callback), context, (Executor)CellCuratorFramework.this.executor));
        }

        public ErrorListenerPathAndBytesable<T> inBackground(BackgroundCallback callback, Executor executor) {
            return new ErrorListenerPathAndBytesableDecorator((ErrorListenerPathAndBytesable)this.inner.inBackground(CellCuratorFramework.wrap(callback), executor));
        }

        public ErrorListenerPathAndBytesable<T> inBackground(BackgroundCallback callback, Object context, Executor executor) {
            return new ErrorListenerPathAndBytesableDecorator((ErrorListenerPathAndBytesable)this.inner.inBackground(CellCuratorFramework.wrap(callback), context, executor));
        }

        public ACLBackgroundPathAndBytesable<T> withMode(CreateMode mode) {
            return new ACLBackgroundPathAndBytesableDecorator((ACLBackgroundPathAndBytesable)this.inner.withMode(mode));
        }

        public T forPath(String path, byte[] data) throws Exception {
            return (T)this.inner.forPath(path, data);
        }

        public T forPath(String path) throws Exception {
            return (T)this.inner.forPath(path);
        }

        public BackgroundPathAndBytesable<T> withACL(List<ACL> list, boolean b) {
            return new BackgroundPathAndBytesableDecorator((BackgroundPathAndBytesable)this.inner.withACL(list, b));
        }

        public ACLCreateModeBackgroundPathAndBytesable<T> storingStatIn(Stat stat) {
            return new ACLCreateModeBackgroundPathAndBytesableDecorator((ACLCreateModeBackgroundPathAndBytesable)this.inner.storingStatIn(stat));
        }
    }

    private class ACLCreateModeBackgroundPathAndBytesableDecorator<T>
    implements ACLCreateModeBackgroundPathAndBytesable<T> {
        private final ACLCreateModeBackgroundPathAndBytesable<T> inner;

        public ACLCreateModeBackgroundPathAndBytesableDecorator(ACLCreateModeBackgroundPathAndBytesable<T> inner) {
            this.inner = inner;
        }

        public BackgroundPathAndBytesable<T> withACL(List<ACL> aclList) {
            return new BackgroundPathAndBytesableDecorator((BackgroundPathAndBytesable)this.inner.withACL(aclList));
        }

        public ErrorListenerPathAndBytesable<T> inBackground() {
            return new ErrorListenerPathAndBytesableDecorator((ErrorListenerPathAndBytesable)this.inner.inBackground());
        }

        public ErrorListenerPathAndBytesable<T> inBackground(Object context) {
            return new ErrorListenerPathAndBytesableDecorator((ErrorListenerPathAndBytesable)this.inner.inBackground(context));
        }

        public ErrorListenerPathAndBytesable<T> inBackground(BackgroundCallback callback) {
            return new ErrorListenerPathAndBytesableDecorator((ErrorListenerPathAndBytesable)this.inner.inBackground(CellCuratorFramework.wrap(callback), (Executor)CellCuratorFramework.this.executor));
        }

        public ErrorListenerPathAndBytesable<T> inBackground(BackgroundCallback callback, Object context) {
            return new ErrorListenerPathAndBytesableDecorator((ErrorListenerPathAndBytesable)this.inner.inBackground(CellCuratorFramework.wrap(callback), context, (Executor)CellCuratorFramework.this.executor));
        }

        public ErrorListenerPathAndBytesable<T> inBackground(BackgroundCallback callback, Executor executor) {
            return new ErrorListenerPathAndBytesableDecorator((ErrorListenerPathAndBytesable)this.inner.inBackground(CellCuratorFramework.wrap(callback), executor));
        }

        public ErrorListenerPathAndBytesable<T> inBackground(BackgroundCallback callback, Object context, Executor executor) {
            return new ErrorListenerPathAndBytesableDecorator((ErrorListenerPathAndBytesable)this.inner.inBackground(CellCuratorFramework.wrap(callback), context, executor));
        }

        public ACLBackgroundPathAndBytesable<T> withMode(CreateMode mode) {
            return new ACLBackgroundPathAndBytesableDecorator((ACLBackgroundPathAndBytesable)this.inner.withMode(mode));
        }

        public T forPath(String path, byte[] data) throws Exception {
            return (T)this.inner.forPath(path, data);
        }

        public T forPath(String path) throws Exception {
            return (T)this.inner.forPath(path);
        }

        public BackgroundPathAndBytesable<T> withACL(List<ACL> list, boolean b) {
            return new BackgroundPathAndBytesableDecorator((BackgroundPathAndBytesable)this.inner.withACL(list, b));
        }
    }

    private static class ACLPathAndBytesableDecorator<T>
    implements ACLPathAndBytesable<T> {
        private final ACLPathAndBytesable<T> inner;

        public ACLPathAndBytesableDecorator(ACLPathAndBytesable<T> inner) {
            this.inner = inner;
        }

        public PathAndBytesable<T> withACL(List<ACL> aclList) {
            return new PathAndBytesableDecorator((PathAndBytesable)this.inner.withACL(aclList));
        }

        public T forPath(String path, byte[] data) throws Exception {
            return (T)this.inner.forPath(path, data);
        }

        public T forPath(String path) throws Exception {
            return (T)this.inner.forPath(path);
        }

        public PathAndBytesable<T> withACL(List<ACL> list, boolean b) {
            return new PathAndBytesableDecorator((PathAndBytesable)this.inner.withACL(list, b));
        }
    }

    private class ProtectACLCreateModeStatPathAndBytesableDecorator<T>
    implements ProtectACLCreateModeStatPathAndBytesable<T> {
        private final ProtectACLCreateModeStatPathAndBytesable<T> inner;

        public ProtectACLCreateModeStatPathAndBytesableDecorator(ProtectACLCreateModeStatPathAndBytesable<T> inner) {
            this.inner = inner;
        }

        public ACLCreateModeBackgroundPathAndBytesable<String> withProtection() {
            return new ACLCreateModeBackgroundPathAndBytesableDecorator<String>(this.inner.withProtection());
        }

        public BackgroundPathAndBytesable<T> withACL(List<ACL> aclList) {
            return new BackgroundPathAndBytesableDecorator((BackgroundPathAndBytesable)this.inner.withACL(aclList));
        }

        public ErrorListenerPathAndBytesable<T> inBackground() {
            return new ErrorListenerPathAndBytesableDecorator((ErrorListenerPathAndBytesable)this.inner.inBackground());
        }

        public ErrorListenerPathAndBytesable<T> inBackground(Object context) {
            return new ErrorListenerPathAndBytesableDecorator((ErrorListenerPathAndBytesable)this.inner.inBackground(context));
        }

        public ErrorListenerPathAndBytesable<T> inBackground(BackgroundCallback callback) {
            return new ErrorListenerPathAndBytesableDecorator((ErrorListenerPathAndBytesable)this.inner.inBackground(CellCuratorFramework.wrap(callback), (Executor)CellCuratorFramework.this.executor));
        }

        public ErrorListenerPathAndBytesable<T> inBackground(BackgroundCallback callback, Object context) {
            return new ErrorListenerPathAndBytesableDecorator((ErrorListenerPathAndBytesable)this.inner.inBackground(CellCuratorFramework.wrap(callback), context, (Executor)CellCuratorFramework.this.executor));
        }

        public ErrorListenerPathAndBytesable<T> inBackground(BackgroundCallback callback, Executor executor) {
            return new ErrorListenerPathAndBytesableDecorator((ErrorListenerPathAndBytesable)this.inner.inBackground(CellCuratorFramework.wrap(callback), executor));
        }

        public ErrorListenerPathAndBytesable<T> inBackground(BackgroundCallback callback, Object context, Executor executor) {
            return new ErrorListenerPathAndBytesableDecorator((ErrorListenerPathAndBytesable)this.inner.inBackground(CellCuratorFramework.wrap(callback), context, executor));
        }

        public ACLBackgroundPathAndBytesable<T> withMode(CreateMode mode) {
            return new ACLBackgroundPathAndBytesableDecorator((ACLBackgroundPathAndBytesable)this.inner.withMode(mode));
        }

        public T forPath(String path, byte[] data) throws Exception {
            return (T)this.inner.forPath(path, data);
        }

        public T forPath(String path) throws Exception {
            return (T)this.inner.forPath(path);
        }

        public BackgroundPathAndBytesable<T> withACL(List<ACL> list, boolean b) {
            return new BackgroundPathAndBytesableDecorator((BackgroundPathAndBytesable)this.inner.withACL(list, b));
        }

        public ACLBackgroundPathAndBytesable<T> storingStatIn(Stat stat) {
            return new ACLBackgroundPathAndBytesableDecorator((ACLBackgroundPathAndBytesable)this.inner.storingStatIn(stat));
        }
    }

    private class SyncBuilderDecorator
    implements SyncBuilder {
        private final SyncBuilder inner;

        public SyncBuilderDecorator(SyncBuilder inner) {
            this.inner = inner;
        }

        public ErrorListenerPathable<Void> inBackground() {
            return new ErrorListenerPathableDecorator<Void>((ErrorListenerPathable)this.inner.inBackground());
        }

        public ErrorListenerPathable<Void> inBackground(Object context) {
            return new ErrorListenerPathableDecorator<Void>((ErrorListenerPathable)this.inner.inBackground(context));
        }

        public ErrorListenerPathable<Void> inBackground(BackgroundCallback callback) {
            return new ErrorListenerPathableDecorator<Void>((ErrorListenerPathable)this.inner.inBackground(CellCuratorFramework.wrap(callback), (Executor)CellCuratorFramework.this.executor));
        }

        public ErrorListenerPathable<Void> inBackground(BackgroundCallback callback, Object context) {
            return new ErrorListenerPathableDecorator<Void>((ErrorListenerPathable)this.inner.inBackground(CellCuratorFramework.wrap(callback), context, (Executor)CellCuratorFramework.this.executor));
        }

        public ErrorListenerPathable<Void> inBackground(BackgroundCallback callback, Executor executor) {
            return new ErrorListenerPathableDecorator<Void>((ErrorListenerPathable)this.inner.inBackground(CellCuratorFramework.wrap(callback), executor));
        }

        public ErrorListenerPathable<Void> inBackground(BackgroundCallback callback, Object context, Executor executor) {
            return new ErrorListenerPathableDecorator<Void>((ErrorListenerPathable)this.inner.inBackground(CellCuratorFramework.wrap(callback), context, executor));
        }

        public Void forPath(String path) throws Exception {
            return (Void)this.inner.forPath(path);
        }
    }

    private class CuratorTransactionFinalDecorator
    implements CuratorTransactionFinal {
        private final CuratorTransactionFinal inner;

        public CuratorTransactionFinalDecorator(CuratorTransactionFinal inner) {
            this.inner = inner;
        }

        public Collection<CuratorTransactionResult> commit() throws Exception {
            return this.inner.commit();
        }

        public TransactionCreateBuilder create() {
            return new TransactionCreateBuilderDecorator((TransactionCreateBuilder<CuratorTransactionBridge>)this.inner.create());
        }

        public TransactionDeleteBuilder delete() {
            return new TransactionDeleteBuilderDecorator((TransactionDeleteBuilder<CuratorTransactionBridge>)this.inner.delete());
        }

        public TransactionSetDataBuilder setData() {
            return new TransactionSetDataBuilderDecorator((TransactionSetDataBuilder<CuratorTransactionBridge>)this.inner.setData());
        }

        public TransactionCheckBuilder check() {
            return new TransactionCheckBuilderDecorator((TransactionCheckBuilder<CuratorTransactionBridge>)this.inner.check());
        }
    }

    private class CuratorTransactionBridgeDecorator
    implements CuratorTransactionBridge {
        private final CuratorTransactionBridge inner;

        public CuratorTransactionBridgeDecorator(CuratorTransactionBridge inner) {
            this.inner = inner;
        }

        public CuratorTransactionFinal and() {
            return new CuratorTransactionFinalDecorator(this.inner.and());
        }
    }

    private class TransactionCheckBuilderDecorator
    implements TransactionCheckBuilder {
        private final TransactionCheckBuilder<CuratorTransactionBridge> inner;

        public TransactionCheckBuilderDecorator(TransactionCheckBuilder<CuratorTransactionBridge> inner) {
            this.inner = inner;
        }

        public CuratorTransactionBridge forPath(String path) throws Exception {
            return new CuratorTransactionBridgeDecorator((CuratorTransactionBridge)this.inner.forPath(path));
        }

        public Pathable<CuratorTransactionBridge> withVersion(int version) {
            return new PathableCuratorTransactionBridgeDecorator((Pathable<CuratorTransactionBridge>)((Pathable)this.inner.withVersion(version)));
        }
    }

    private class TransactionSetDataBuilderDecorator
    implements TransactionSetDataBuilder {
        private final TransactionSetDataBuilder<CuratorTransactionBridge> inner;

        public TransactionSetDataBuilderDecorator(TransactionSetDataBuilder<CuratorTransactionBridge> inner) {
            this.inner = inner;
        }

        public VersionPathAndBytesable<CuratorTransactionBridge> compressed() {
            return new VersionPathAndBytesableCuratorTransactionBridgeDecorator((VersionPathAndBytesable<CuratorTransactionBridge>)((VersionPathAndBytesable)this.inner.compressed()));
        }

        public CuratorTransactionBridge forPath(String path, byte[] data) throws Exception {
            return new CuratorTransactionBridgeDecorator((CuratorTransactionBridge)this.inner.forPath(path, data));
        }

        public CuratorTransactionBridge forPath(String path) throws Exception {
            return new CuratorTransactionBridgeDecorator((CuratorTransactionBridge)this.inner.forPath(path));
        }

        public PathAndBytesable<CuratorTransactionBridge> withVersion(int version) {
            return new PathAndBytesableCuratorTransactionBridgeDecorator((PathAndBytesable<CuratorTransactionBridge>)((PathAndBytesable)this.inner.withVersion(version)));
        }
    }

    private class TransactionDeleteBuilderDecorator
    implements TransactionDeleteBuilder {
        private final TransactionDeleteBuilder<CuratorTransactionBridge> inner;

        public TransactionDeleteBuilderDecorator(TransactionDeleteBuilder<CuratorTransactionBridge> inner) {
            this.inner = inner;
        }

        public CuratorTransactionBridge forPath(String path) throws Exception {
            return new CuratorTransactionBridgeDecorator((CuratorTransactionBridge)this.inner.forPath(path));
        }

        public Pathable<CuratorTransactionBridge> withVersion(int version) {
            return new PathableCuratorTransactionBridgeDecorator((Pathable<CuratorTransactionBridge>)((Pathable)this.inner.withVersion(version)));
        }
    }

    private class TransactionCreateBuilderDecorator
    implements TransactionCreateBuilder {
        private final TransactionCreateBuilder<CuratorTransactionBridge> inner;

        public TransactionCreateBuilderDecorator(TransactionCreateBuilder<CuratorTransactionBridge> inner) {
            this.inner = inner;
        }

        public PathAndBytesable<CuratorTransactionBridge> withACL(List list) {
            return new PathAndBytesableDecorator<CuratorTransactionBridge>((PathAndBytesable)this.inner.withACL(list));
        }

        public ACLCreateModePathAndBytesable<CuratorTransactionBridge> compressed() {
            return new ACLCreateModePathAndBytesableDecorator<CuratorTransactionBridge>((ACLCreateModePathAndBytesable)this.inner.compressed());
        }

        public ACLPathAndBytesable<CuratorTransactionBridge> withMode(CreateMode mode) {
            return new ACLPathAndBytesableDecorator<CuratorTransactionBridge>((ACLPathAndBytesable)this.inner.withMode(mode));
        }

        public CuratorTransactionBridge forPath(String path, byte[] data) throws Exception {
            return new CuratorTransactionBridgeDecorator((CuratorTransactionBridge)this.inner.forPath(path, data));
        }

        public CuratorTransactionBridge forPath(String path) throws Exception {
            return new CuratorTransactionBridgeDecorator((CuratorTransactionBridge)this.inner.forPath(path));
        }

        public TransactionCreateBuilder2 withTtl(long l) {
            return this.inner.withTtl(l);
        }

        public PathAndBytesable<CuratorTransactionBridge> withACL(List list, boolean b) {
            return new PathAndBytesableDecorator<CuratorTransactionBridge>((PathAndBytesable)this.inner.withACL(list, b));
        }
    }

    private class CuratorTransactionDecorator
    implements CuratorTransaction {
        private final CuratorTransaction inner;

        public CuratorTransactionDecorator(CuratorTransaction inner) {
            this.inner = inner;
        }

        public TransactionCreateBuilder create() {
            return new TransactionCreateBuilderDecorator((TransactionCreateBuilder<CuratorTransactionBridge>)this.inner.create());
        }

        public TransactionDeleteBuilder delete() {
            return new TransactionDeleteBuilderDecorator((TransactionDeleteBuilder<CuratorTransactionBridge>)this.inner.delete());
        }

        public TransactionSetDataBuilder setData() {
            return new TransactionSetDataBuilderDecorator((TransactionSetDataBuilder<CuratorTransactionBridge>)this.inner.setData());
        }

        public TransactionCheckBuilder check() {
            return new TransactionCheckBuilderDecorator((TransactionCheckBuilder<CuratorTransactionBridge>)this.inner.check());
        }
    }

    private class SetACLBuilderDecorator
    implements SetACLBuilder {
        private final SetACLBuilder inner;

        public SetACLBuilderDecorator(SetACLBuilder inner) {
            this.inner = inner;
        }

        public BackgroundPathable<Stat> withACL(List<ACL> aclList) {
            return new BackgroundPathableDecorator<Stat>((BackgroundPathable)this.inner.withACL(aclList));
        }

        public ACLable<BackgroundPathable<Stat>> withVersion(int version) {
            return new ACLableBackgroundPathableDecorator<Stat>((ACLable)this.inner.withVersion(version));
        }
    }

    private class GetACLBuilderDecorator
    implements GetACLBuilder {
        private final GetACLBuilder inner;

        public GetACLBuilderDecorator(GetACLBuilder inner) {
            this.inner = inner;
        }

        public ErrorListenerPathable<List<ACL>> inBackground() {
            return new ErrorListenerPathableDecorator<List<ACL>>((ErrorListenerPathable)this.inner.inBackground());
        }

        public ErrorListenerPathable<List<ACL>> inBackground(Object context) {
            return new ErrorListenerPathableDecorator<List<ACL>>((ErrorListenerPathable)this.inner.inBackground(context));
        }

        public ErrorListenerPathable<List<ACL>> inBackground(BackgroundCallback callback) {
            return new ErrorListenerPathableDecorator<List<ACL>>((ErrorListenerPathable)this.inner.inBackground(CellCuratorFramework.wrap(callback), (Executor)CellCuratorFramework.this.executor));
        }

        public ErrorListenerPathable<List<ACL>> inBackground(BackgroundCallback callback, Object context) {
            return new ErrorListenerPathableDecorator<List<ACL>>((ErrorListenerPathable)this.inner.inBackground(CellCuratorFramework.wrap(callback), context, (Executor)CellCuratorFramework.this.executor));
        }

        public ErrorListenerPathable<List<ACL>> inBackground(BackgroundCallback callback, Executor executor) {
            return new ErrorListenerPathableDecorator<List<ACL>>((ErrorListenerPathable)this.inner.inBackground(CellCuratorFramework.wrap(callback), executor));
        }

        public ErrorListenerPathable<List<ACL>> inBackground(BackgroundCallback callback, Object context, Executor executor) {
            return new ErrorListenerPathableDecorator<List<ACL>>((ErrorListenerPathable)this.inner.inBackground(CellCuratorFramework.wrap(callback), context, executor));
        }

        public List<ACL> forPath(String path) throws Exception {
            return (List)this.inner.forPath(path);
        }

        public Pathable<List<ACL>> storingStatIn(Stat stat) {
            return new PathableDecorator<List<ACL>>((Pathable)this.inner.storingStatIn(stat));
        }
    }

    private class GetChildrenBuilderDecorator
    implements GetChildrenBuilder {
        private final GetChildrenBuilder inner;

        public GetChildrenBuilderDecorator(GetChildrenBuilder inner) {
            this.inner = inner;
        }

        public ErrorListenerPathable<List<String>> inBackground() {
            return new ErrorListenerPathableDecorator<List<String>>((ErrorListenerPathable)this.inner.inBackground());
        }

        public ErrorListenerPathable<List<String>> inBackground(Object context) {
            return new ErrorListenerPathableDecorator<List<String>>((ErrorListenerPathable)this.inner.inBackground(context));
        }

        public ErrorListenerPathable<List<String>> inBackground(BackgroundCallback callback) {
            return new ErrorListenerPathableDecorator<List<String>>((ErrorListenerPathable)this.inner.inBackground(CellCuratorFramework.wrap(callback), (Executor)CellCuratorFramework.this.executor));
        }

        public ErrorListenerPathable<List<String>> inBackground(BackgroundCallback callback, Object context) {
            return new ErrorListenerPathableDecorator<List<String>>((ErrorListenerPathable)this.inner.inBackground(CellCuratorFramework.wrap(callback), context, (Executor)CellCuratorFramework.this.executor));
        }

        public ErrorListenerPathable<List<String>> inBackground(BackgroundCallback callback, Executor executor) {
            return new ErrorListenerPathableDecorator<List<String>>((ErrorListenerPathable)this.inner.inBackground(CellCuratorFramework.wrap(callback), executor));
        }

        public ErrorListenerPathable<List<String>> inBackground(BackgroundCallback callback, Object context, Executor executor) {
            return new ErrorListenerPathableDecorator<List<String>>((ErrorListenerPathable)this.inner.inBackground(CellCuratorFramework.wrap(callback), context, executor));
        }

        public List<String> forPath(String path) throws Exception {
            return (List)this.inner.forPath(path);
        }

        public WatchPathable<List<String>> storingStatIn(Stat stat) {
            return new WatchPathableDecorator<List<String>>((WatchPathable)this.inner.storingStatIn(stat));
        }

        public BackgroundPathable<List<String>> watched() {
            return new BackgroundPathableDecorator<List<String>>((BackgroundPathable)this.inner.watched());
        }

        public BackgroundPathable<List<String>> usingWatcher(Watcher watcher) {
            return new BackgroundPathableDecorator<List<String>>((BackgroundPathable)this.inner.usingWatcher(CellCuratorFramework.this.wrap(watcher)));
        }

        public BackgroundPathable<List<String>> usingWatcher(CuratorWatcher watcher) {
            return new BackgroundPathableDecorator<List<String>>((BackgroundPathable)this.inner.usingWatcher(CellCuratorFramework.this.wrap(watcher)));
        }
    }

    private class SetDataBuilderDecorator
    implements SetDataBuilder {
        private final SetDataBuilder inner;

        public SetDataBuilderDecorator(SetDataBuilder inner) {
            this.inner = inner;
        }

        public ErrorListenerPathAndBytesable<Stat> inBackground() {
            return new ErrorListenerPathAndBytesableDecorator<Stat>((ErrorListenerPathAndBytesable)this.inner.inBackground());
        }

        public ErrorListenerPathAndBytesable<Stat> inBackground(Object context) {
            return new ErrorListenerPathAndBytesableDecorator<Stat>((ErrorListenerPathAndBytesable)this.inner.inBackground(context));
        }

        public ErrorListenerPathAndBytesable<Stat> inBackground(BackgroundCallback callback) {
            return new ErrorListenerPathAndBytesableDecorator<Stat>((ErrorListenerPathAndBytesable)this.inner.inBackground(CellCuratorFramework.wrap(callback), (Executor)CellCuratorFramework.this.executor));
        }

        public ErrorListenerPathAndBytesable<Stat> inBackground(BackgroundCallback callback, Object context) {
            return new ErrorListenerPathAndBytesableDecorator<Stat>((ErrorListenerPathAndBytesable)this.inner.inBackground(CellCuratorFramework.wrap(callback), context, (Executor)CellCuratorFramework.this.executor));
        }

        public ErrorListenerPathAndBytesable<Stat> inBackground(BackgroundCallback callback, Executor executor) {
            return new ErrorListenerPathAndBytesableDecorator<Stat>((ErrorListenerPathAndBytesable)this.inner.inBackground(CellCuratorFramework.wrap(callback), executor));
        }

        public ErrorListenerPathAndBytesable<Stat> inBackground(BackgroundCallback callback, Object context, Executor executor) {
            return new ErrorListenerPathAndBytesableDecorator<Stat>((ErrorListenerPathAndBytesable)this.inner.inBackground(CellCuratorFramework.wrap(callback), context, executor));
        }

        public SetDataBackgroundVersionable compressed() {
            return new SetDataBackgroundVersionableDecorator((SetDataBackgroundVersionable)this.inner.compressed());
        }

        public Stat forPath(String path, byte[] data) throws Exception {
            return (Stat)this.inner.forPath(path, data);
        }

        public Stat forPath(String path) throws Exception {
            return (Stat)this.inner.forPath(path);
        }

        public BackgroundPathAndBytesable<Stat> withVersion(int version) {
            return new BackgroundPathAndBytesableDecorator<Stat>((BackgroundPathAndBytesable)this.inner.withVersion(version));
        }
    }

    private class GetDataBuilderDecorator
    implements GetDataBuilder {
        private final GetDataBuilder inner;

        public GetDataBuilderDecorator(GetDataBuilder inner) {
            this.inner = inner;
        }

        public ErrorListenerPathable<byte[]> inBackground() {
            return new ErrorListenerPathableDecorator<byte[]>((ErrorListenerPathable)this.inner.inBackground());
        }

        public ErrorListenerPathable<byte[]> inBackground(Object context) {
            return new ErrorListenerPathableDecorator<byte[]>((ErrorListenerPathable)this.inner.inBackground(context));
        }

        public ErrorListenerPathable<byte[]> inBackground(BackgroundCallback callback) {
            return new ErrorListenerPathableDecorator<byte[]>((ErrorListenerPathable)this.inner.inBackground(CellCuratorFramework.wrap(callback), (Executor)CellCuratorFramework.this.executor));
        }

        public ErrorListenerPathable<byte[]> inBackground(BackgroundCallback callback, Object context) {
            return new ErrorListenerPathableDecorator<byte[]>((ErrorListenerPathable)this.inner.inBackground(CellCuratorFramework.wrap(callback), context, (Executor)CellCuratorFramework.this.executor));
        }

        public ErrorListenerPathable<byte[]> inBackground(BackgroundCallback callback, Executor executor) {
            return new ErrorListenerPathableDecorator<byte[]>((ErrorListenerPathable)this.inner.inBackground(CellCuratorFramework.wrap(callback), executor));
        }

        public ErrorListenerPathable<byte[]> inBackground(BackgroundCallback callback, Object context, Executor executor) {
            return new ErrorListenerPathableDecorator<byte[]>((ErrorListenerPathable)this.inner.inBackground(CellCuratorFramework.wrap(callback), context, executor));
        }

        public GetDataWatchBackgroundStatable decompressed() {
            return new GetDataWatchBackgroundStatableDecorator((GetDataWatchBackgroundStatable)this.inner.decompressed());
        }

        public byte[] forPath(String path) throws Exception {
            return (byte[])this.inner.forPath(path);
        }

        public WatchPathable<byte[]> storingStatIn(Stat stat) {
            return new WatchPathableDecorator<byte[]>((WatchPathable)this.inner.storingStatIn(stat));
        }

        public BackgroundPathable<byte[]> watched() {
            return new BackgroundPathableDecorator<byte[]>((BackgroundPathable)this.inner.watched());
        }

        public BackgroundPathable<byte[]> usingWatcher(Watcher watcher) {
            return new BackgroundPathableDecorator<byte[]>((BackgroundPathable)this.inner.usingWatcher(CellCuratorFramework.this.wrap(watcher)));
        }

        public BackgroundPathable<byte[]> usingWatcher(CuratorWatcher watcher) {
            return new BackgroundPathableDecorator<byte[]>((BackgroundPathable)this.inner.usingWatcher(CellCuratorFramework.this.wrap(watcher)));
        }
    }

    private class ExistsBuilderDecorator
    extends ExistsBuilderMainDecorator
    implements ExistsBuilder {
        public ExistsBuilderDecorator(ExistsBuilder inner) {
            super(inner);
        }

        public ACLableExistBuilderMain creatingParentsIfNeeded() {
            return this.inner.creatingParentsIfNeeded();
        }

        public ACLableExistBuilderMain creatingParentContainersIfNeeded() {
            return this.inner.creatingParentContainersIfNeeded();
        }
    }

    private class ExistsBuilderMainDecorator
    implements ExistsBuilderMain {
        protected final ExistsBuilder inner;

        public ExistsBuilderMainDecorator(ExistsBuilder inner) {
            this.inner = inner;
        }

        public ErrorListenerPathable<Stat> inBackground() {
            return new ErrorListenerPathableDecorator<Stat>((ErrorListenerPathable)this.inner.inBackground());
        }

        public ErrorListenerPathable<Stat> inBackground(Object context) {
            return new ErrorListenerPathableDecorator<Stat>((ErrorListenerPathable)this.inner.inBackground(context));
        }

        public ErrorListenerPathable<Stat> inBackground(BackgroundCallback callback) {
            return new ErrorListenerPathableDecorator<Stat>((ErrorListenerPathable)this.inner.inBackground(CellCuratorFramework.wrap(callback), (Executor)CellCuratorFramework.this.executor));
        }

        public ErrorListenerPathable<Stat> inBackground(BackgroundCallback callback, Object context) {
            return new ErrorListenerPathableDecorator<Stat>((ErrorListenerPathable)this.inner.inBackground(CellCuratorFramework.wrap(callback), context, (Executor)CellCuratorFramework.this.executor));
        }

        public ErrorListenerPathable<Stat> inBackground(BackgroundCallback callback, Executor executor) {
            return new ErrorListenerPathableDecorator<Stat>((ErrorListenerPathable)this.inner.inBackground(CellCuratorFramework.wrap(callback), executor));
        }

        public ErrorListenerPathable<Stat> inBackground(BackgroundCallback callback, Object context, Executor executor) {
            return new ErrorListenerPathableDecorator<Stat>((ErrorListenerPathable)this.inner.inBackground(CellCuratorFramework.wrap(callback), context, executor));
        }

        public Stat forPath(String path) throws Exception {
            return (Stat)this.inner.forPath(path);
        }

        public BackgroundPathable<Stat> watched() {
            return new BackgroundPathableDecorator<Stat>((BackgroundPathable)this.inner.watched());
        }

        public BackgroundPathable<Stat> usingWatcher(Watcher watcher) {
            return new BackgroundPathableDecorator<Stat>((BackgroundPathable)this.inner.usingWatcher(CellCuratorFramework.this.wrap(watcher)));
        }

        public BackgroundPathable<Stat> usingWatcher(CuratorWatcher watcher) {
            return new BackgroundPathableDecorator<Stat>((BackgroundPathable)this.inner.usingWatcher(CellCuratorFramework.this.wrap(watcher)));
        }
    }

    private class DeleteBuilderDecorator
    implements DeleteBuilder {
        private final DeleteBuilder inner;

        private DeleteBuilderDecorator(DeleteBuilder inner) {
            this.inner = inner;
        }

        public BackgroundVersionable deletingChildrenIfNeeded() {
            return new BackgroundVersionableDecorator(this.inner.deletingChildrenIfNeeded());
        }

        public ChildrenDeletable guaranteed() {
            return new ChildrenDeletableDecorator((ChildrenDeletable)this.inner.guaranteed());
        }

        public ErrorListenerPathable<Void> inBackground() {
            return new ErrorListenerPathableDecorator<Void>((ErrorListenerPathable)this.inner.inBackground());
        }

        public ErrorListenerPathable<Void> inBackground(Object context) {
            return new ErrorListenerPathableDecorator<Void>((ErrorListenerPathable)this.inner.inBackground(context));
        }

        public ErrorListenerPathable<Void> inBackground(BackgroundCallback callback) {
            return new ErrorListenerPathableDecorator<Void>((ErrorListenerPathable)this.inner.inBackground(CellCuratorFramework.wrap(callback), (Executor)CellCuratorFramework.this.executor));
        }

        public ErrorListenerPathable<Void> inBackground(BackgroundCallback callback, Object context) {
            return new ErrorListenerPathableDecorator<Void>((ErrorListenerPathable)this.inner.inBackground(CellCuratorFramework.wrap(callback), context, (Executor)CellCuratorFramework.this.executor));
        }

        public ErrorListenerPathable<Void> inBackground(BackgroundCallback callback, Executor executor) {
            return new ErrorListenerPathableDecorator<Void>((ErrorListenerPathable)this.inner.inBackground(CellCuratorFramework.wrap(callback), executor));
        }

        public ErrorListenerPathable<Void> inBackground(BackgroundCallback callback, Object context, Executor executor) {
            return new ErrorListenerPathableDecorator<Void>((ErrorListenerPathable)this.inner.inBackground(CellCuratorFramework.wrap(callback), context, executor));
        }

        public Void forPath(String path) throws Exception {
            return (Void)this.inner.forPath(path);
        }

        public BackgroundPathable<Void> withVersion(int version) {
            return (BackgroundPathable)this.inner.withVersion(version);
        }

        public DeleteBuilderMain quietly() {
            return (DeleteBuilderMain)this.inner.quietly();
        }
    }

    private class CreateBuilderDecorator
    implements CreateBuilder {
        private final CreateBuilder inner;

        public CreateBuilderDecorator(CreateBuilder inner) {
            this.inner = inner;
        }

        public ProtectACLCreateModeStatPathAndBytesable<String> creatingParentsIfNeeded() {
            return new ProtectACLCreateModeStatPathAndBytesableDecorator<String>(this.inner.creatingParentsIfNeeded());
        }

        public ProtectACLCreateModeStatPathAndBytesable<String> creatingParentContainersIfNeeded() {
            return new ProtectACLCreateModeStatPathAndBytesableDecorator<String>(this.inner.creatingParentContainersIfNeeded());
        }

        public ACLPathAndBytesable<String> withProtectedEphemeralSequential() {
            return new ACLPathAndBytesableDecorator<String>(this.inner.withProtectedEphemeralSequential());
        }

        public ACLCreateModeStatBackgroundPathAndBytesable<String> withProtection() {
            return new ACLCreateModeStatBackgroundPathAndBytesableDecorator<String>(this.inner.withProtection());
        }

        public BackgroundPathAndBytesable<String> withACL(List<ACL> aclList) {
            return new BackgroundPathAndBytesableDecorator<String>((BackgroundPathAndBytesable)this.inner.withACL(aclList));
        }

        public ErrorListenerPathAndBytesable<String> inBackground() {
            return new ErrorListenerPathAndBytesableDecorator<String>((ErrorListenerPathAndBytesable)this.inner.inBackground());
        }

        public ErrorListenerPathAndBytesable<String> inBackground(Object context) {
            return new ErrorListenerPathAndBytesableDecorator<String>((ErrorListenerPathAndBytesable)this.inner.inBackground(context));
        }

        public ErrorListenerPathAndBytesable<String> inBackground(BackgroundCallback callback) {
            return new ErrorListenerPathAndBytesableDecorator<String>((ErrorListenerPathAndBytesable)this.inner.inBackground(CellCuratorFramework.wrap(callback), (Executor)CellCuratorFramework.this.executor));
        }

        public ErrorListenerPathAndBytesable<String> inBackground(BackgroundCallback callback, Object context) {
            return new ErrorListenerPathAndBytesableDecorator<String>((ErrorListenerPathAndBytesable)this.inner.inBackground(CellCuratorFramework.wrap(callback), context, (Executor)CellCuratorFramework.this.executor));
        }

        public ErrorListenerPathAndBytesable<String> inBackground(BackgroundCallback callback, Executor executor) {
            return new ErrorListenerPathAndBytesableDecorator<String>((ErrorListenerPathAndBytesable)this.inner.inBackground(CellCuratorFramework.wrap(callback), executor));
        }

        public ErrorListenerPathAndBytesable<String> inBackground(BackgroundCallback callback, Object context, Executor executor) {
            return new ErrorListenerPathAndBytesableDecorator<String>((ErrorListenerPathAndBytesable)this.inner.inBackground(CellCuratorFramework.wrap(callback), context, executor));
        }

        public ACLBackgroundPathAndBytesable<String> withMode(CreateMode mode) {
            return new ACLBackgroundPathAndBytesableDecorator<String>((ACLBackgroundPathAndBytesable)this.inner.withMode(mode));
        }

        public String forPath(String path, byte[] data) throws Exception {
            return (String)this.inner.forPath(path, data);
        }

        public String forPath(String path) throws Exception {
            return (String)this.inner.forPath(path);
        }

        public CreateBuilderMain withTtl(long l) {
            return this.inner.withTtl(l);
        }

        public CreateBuilder2 orSetData() {
            return this.inner.orSetData();
        }

        public CreateBuilder2 orSetData(int i) {
            return this.inner.orSetData(i);
        }

        public BackgroundPathAndBytesable<String> withACL(List<ACL> list, boolean b) {
            return (BackgroundPathAndBytesable)this.inner.withACL(list, b);
        }

        public CreateProtectACLCreateModePathAndBytesable<String> storingStatIn(Stat stat) {
            return (CreateProtectACLCreateModePathAndBytesable)this.inner.storingStatIn(stat);
        }

        public CreateBackgroundModeStatACLable compressed() {
            return new CreateBackgroundModeStatACLableDecorator((CreateBackgroundModeStatACLable)this.inner.compressed());
        }
    }

    private static class ListenableDecorator<T>
    implements Listenable<T> {
        private final Listenable<T> listenable;
        private final Executor executor;

        public ListenableDecorator(Listenable<T> listenable, Executor executor) {
            this.listenable = listenable;
            this.executor = executor;
        }

        public void addListener(T listener) {
            this.addListener(listener, this.executor);
        }

        public void addListener(T listener, Executor executor) {
            CDC cdc = new CDC();
            this.listenable.addListener(listener, r -> executor.execute(() -> cdc.execute(r)));
        }

        public void removeListener(T listener) {
            this.listenable.removeListener(listener);
        }
    }
}

