/*
 * Decompiled with CFR 0.152.
 */
package dmg.util;

import dmg.util.LineWriter;
import java.io.Writer;

public class BufferedLineWriter
extends Writer {
    private final LineWriter _writer;
    private final StringBuilder _buffer;

    public BufferedLineWriter(LineWriter writer) {
        this._writer = writer;
        this._buffer = new StringBuilder();
    }

    @Override
    public void close() {
        this.flush();
    }

    private void flushCompletedLines() {
        int i;
        while ((i = this._buffer.indexOf("\n")) > -1) {
            this._writer.writeLine(this._buffer.substring(0, i));
            this._buffer.delete(0, i + 1);
        }
    }

    @Override
    public void flush() {
        this.flushCompletedLines();
        if (this._buffer.length() > 0) {
            this._writer.writeLine(this._buffer.toString());
            this._buffer.delete(0, this._buffer.length());
        }
    }

    @Override
    public void write(char[] cbuf, int off, int len) {
        this._buffer.append(cbuf, off, len);
        this.flushCompletedLines();
    }
}

