/*
 * Decompiled with CFR 0.152.
 */
package dmg.util;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.TreeSet;

public class CellCron
implements Runnable {
    public static final int NEXT = -1;
    private final TreeSet<TimerTask> _list = new TreeSet();

    public TimerTask add(int minutes, TaskRunnable runner, String name) {
        return this.add(-1, minutes, runner, name);
    }

    public TimerTask add(int hour, int minutes, TaskRunnable runner, String name) {
        TimerTask task = new TimerTask(hour, minutes, runner, name);
        this.add(task);
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(TimerTask task) {
        TreeSet<TimerTask> treeSet = this._list;
        synchronized (treeSet) {
            while (this._list.contains(task)) {
                task.nextTick();
            }
            this._list.add(task);
            this._list.notifyAll();
        }
    }

    public Iterator<TimerTask> iterator() {
        return new ArrayList<TimerTask>(this._list).iterator();
    }

    @Override
    public void run() {
        try {
            this.runLoop();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runLoop() throws InterruptedException {
        while (!Thread.interrupted()) {
            TreeSet<TimerTask> treeSet = this._list;
            synchronized (treeSet) {
                if (this._list.isEmpty()) {
                    this._list.wait(300000L);
                    continue;
                }
                TimerTask task = this._list.first();
                long diff = task.getTime() - System.currentTimeMillis();
                if (diff < 15000L) {
                    this._list.remove(task);
                    try {
                        task._runner.run(task);
                    }
                    catch (Exception ee) {
                        ee.printStackTrace();
                    }
                } else if (diff > 300000L) {
                    this._list.wait(diff - 60000L);
                } else {
                    this._list.wait(diff);
                }
            }
        }
    }

    public static interface TaskRunnable {
        public void run(TimerTask var1);
    }

    public class TimerTask
    implements Comparable<TimerTask> {
        private Long _time;
        private Calendar _calendar;
        private String _name;
        private TaskRunnable _runner;

        private TimerTask(int hour, int minute, TaskRunnable runner, String name) {
            this._runner = runner;
            this._name = name;
            this._calendar = new GregorianCalendar();
            long start = this._calendar.getTime().getTime();
            if (hour != -1) {
                this._calendar.set(11, hour);
            }
            this._calendar.set(12, minute);
            this._calendar.set(13, 0);
            this._time = this._calendar.getTime().getTime();
            if (this._time - start < 0L) {
                if (hour == -1) {
                    this._calendar.set(11, this._calendar.get(11) + 1);
                } else {
                    this._calendar.set(6, this._calendar.get(6) + 1);
                }
            }
            this._time = this._calendar.getTime().getTime();
        }

        public Calendar getCalendar() {
            return this._calendar;
        }

        private void nextTick() {
            this._time = this._time + 1L;
        }

        @Override
        public int compareTo(TimerTask other) {
            return this._time.compareTo(other._time);
        }

        public int hashCode() {
            return 17;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            return other instanceof TimerTask && this._time.equals(((TimerTask)other)._time);
        }

        public void repeatTomorrow() {
            this.tomorrow();
            CellCron.this.add(this);
        }

        public void repeatNextHour() {
            this._calendar.set(12, this._calendar.get(12) + 60);
            this._time = this._calendar.getTime().getTime();
            CellCron.this.add(this);
        }

        private void tomorrow() {
            this._calendar.set(6, this._calendar.get(6) + 1);
            this._time = this._calendar.getTime().getTime();
        }

        private long getTime() {
            return this._time;
        }

        public String toString() {
            return this._name + " " + new Date(this._time);
        }
    }
}

