/*
 * Decompiled with CFR 0.152.
 */
package dmg.util;

import dmg.util.CommandException;
import dmg.util.CommandExitException;
import dmg.util.CommandPanicException;
import dmg.util.CommandSyntaxException;
import dmg.util.CommandThrowableException;
import dmg.util.command.AcCommandScanner;
import java.io.Serializable;
import org.dcache.util.Args;
import org.dcache.util.cli.AnnotatedCommandScanner;
import org.dcache.util.cli.CommandScanner;

public class CommandInterpreter
extends org.dcache.util.cli.CommandInterpreter {
    public CommandInterpreter() {
        this.addCommandScanner((CommandScanner)new AnnotatedCommandScanner());
        this.addCommandScanner(new AcCommandScanner());
        this.addCommandListener((Object)this);
    }

    public CommandInterpreter(Object commandListener) {
        this.addCommandScanner((CommandScanner)new AnnotatedCommandScanner());
        this.addCommandScanner(new AcCommandScanner());
        this.addCommandListener(commandListener);
    }

    public String command(String str) throws CommandExitException {
        if (str.trim().isEmpty()) {
            return "";
        }
        try {
            Serializable o = this.command(new Args((CharSequence)str));
            if (o == null) {
                return "";
            }
            return (String)((Object)o);
        }
        catch (CommandSyntaxException e) {
            StringBuilder sb = new StringBuilder();
            sb.append("Syntax Error : ").append(e.getMessage()).append('\n');
            String help = e.getHelpText();
            if (help != null) {
                sb.append("Help : \n");
                sb.append(help);
            }
            return sb.toString();
        }
        catch (CommandExitException e) {
            throw e;
        }
        catch (CommandThrowableException e) {
            StringBuilder sb = new StringBuilder();
            sb.append(e.getMessage()).append('\n');
            Throwable t = e.getTargetException();
            sb.append(t.getClass().getName()).append(" : ").append(t.getMessage()).append('\n');
            return sb.toString();
        }
        catch (CommandPanicException e) {
            StringBuilder sb = new StringBuilder();
            sb.append("Panic : ").append(e.getMessage()).append('\n');
            Throwable t = e.getTargetException();
            sb.append(t.getClass().getName()).append(" : ").append(t.getMessage()).append('\n');
            return sb.toString();
        }
        catch (CommandException e) {
            return "??? : " + e;
        }
    }
}

