/*
 * Decompiled with CFR 0.152.
 */
package dmg.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Exceptions {
    private static final Logger LOG = LoggerFactory.getLogger(Exceptions.class);

    private Exceptions() {
    }

    public static String meaningfulMessage(Throwable t) {
        return t.getMessage() != null ? t.getMessage() : t.getClass().getName();
    }

    public static String getMessageWithCauses(Throwable t) {
        StringBuilder msg = new StringBuilder(Exceptions.meaningfulMessage(t));
        for (t = t.getCause(); t != null; t = t.getCause()) {
            msg.append("; caused by: ");
            if (t instanceof RuntimeException) {
                StringWriter w = new StringWriter();
                t.printStackTrace(new PrintWriter(w));
                msg.append(w.getBuffer());
                break;
            }
            msg.append(Exceptions.meaningfulMessage(t));
        }
        return msg.toString();
    }

    public static <T extends Exception> T wrap(String prefix, T cause, Class<T> enclosingType) {
        ReflectiveOperationException lastException = null;
        String causeMessage = cause.getMessage() == null ? cause.getClass().getSimpleName() : cause.getMessage();
        String message = prefix + ": " + causeMessage;
        Class<?> type = cause.getClass();
        while (enclosingType.isAssignableFrom(type)) {
            try {
                Constructor<?> c = type.getConstructor(String.class, Throwable.class);
                return (T)((Exception)c.newInstance(message, cause));
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                lastException = e;
                try {
                    Constructor<?> c = type.getConstructor(String.class);
                    return (T)((Exception)c.newInstance(message));
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e2) {
                    lastException = e2;
                    type = type.getSuperclass();
                }
            }
        }
        if (lastException == null) {
            LOG.error("Failed to wrap exception with message {}: exception {} not subclass of {}", new Object[]{message, cause.getClass().getCanonicalName(), enclosingType.getCanonicalName()});
        } else {
            LOG.error("Failed to wrap exception with message {}: {}", (Object)message, (Object)lastException.getMessage());
        }
        return cause;
    }
}

