/*
 * Decompiled with CFR 0.152.
 */
package dmg.util;

import com.google.common.collect.EvictingQueue;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Queue;

public class Pinboard {
    private final Queue<String> _entries;

    public Pinboard(int size) {
        this._entries = EvictingQueue.create((int)size);
    }

    public synchronized void pin(String note) {
        this._entries.add(note);
    }

    public synchronized void dump(StringBuilder sb) {
        this._entries.forEach(e -> sb.append((String)e).append('\n'));
    }

    public synchronized void dump(StringBuilder sb, int last) {
        this._entries.stream().skip(Math.max(0, this._entries.size() - last)).forEach(e -> sb.append((String)e).append('\n'));
    }

    public synchronized void dump(File file) throws IOException {
        try (OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);
             PrintWriter pw = new PrintWriter(w);){
            this._entries.forEach(pw::println);
        }
    }

    public synchronized void dump(File file, int last) throws IOException {
        try (PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));){
            this._entries.stream().skip(Math.max(0, this._entries.size() - last)).forEach(pw::println);
        }
    }
}

