/*
 * Decompiled with CFR 0.152.
 */
package dmg.util;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.layout.EchoLayout;
import dmg.cells.nucleus.CellNucleus;
import dmg.util.Pinboard;

public class PinboardAppender
extends AppenderBase<ILoggingEvent> {
    private static Layout<ILoggingEvent> _layout = new EchoLayout();

    public void setLayout(Layout<ILoggingEvent> layout) {
        if (layout == null) {
            throw new IllegalArgumentException("Null value is not allowed");
        }
        _layout = layout;
    }

    public Layout<ILoggingEvent> getLayout() {
        return _layout;
    }

    protected void append(ILoggingEvent event) {
        Pinboard pinboard;
        String cell = (String)event.getMDCPropertyMap().get("cells.cell");
        CellNucleus nucleus = CellNucleus.getLogTargetForCell(cell);
        if (nucleus != null && (pinboard = nucleus.getPinboard()) != null) {
            pinboard.pin(_layout.doLayout((Object)event));
        }
    }
}

