/*
 * Decompiled with CFR 0.152.
 */
package dmg.util.command;

import dmg.cells.nucleus.DelayedReply;
import dmg.cells.nucleus.Reply;
import dmg.util.CommandPanicException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import org.dcache.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DelayedCommand<T extends Serializable>
extends DelayedReply
implements Callable<Reply>,
Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DelayedCommand.class);
    private final Executor executor;

    protected DelayedCommand() {
        this(command -> new Thread(command).start());
    }

    protected DelayedCommand(Executor executor) {
        this.executor = executor;
    }

    @Override
    public Reply call() {
        this.executor.execute(this);
        return this;
    }

    protected abstract T execute() throws Exception;

    @Override
    public void run() {
        T result;
        try {
            result = this.execute();
        }
        catch (Exception e2) {
            CommandPanicException e2;
            try {
                Method method = ReflectionUtils.getAnyMethod(this.getClass(), (String)"execute", (Class[])new Class[0]);
                if (!ReflectionUtils.hasDeclaredException((Method)method, (Exception)e2)) {
                    LOGGER.error("Command failed due to a bug, please contact support@dcache.org.", (Throwable)e2);
                    e2 = new CommandPanicException("Command failed: " + e2, (Throwable)e2);
                }
            }
            catch (NoSuchMethodException suppressed) {
                e2.addSuppressed(suppressed);
            }
            result = e2;
        }
        this.reply((Serializable)result);
    }
}

