/*
 * Decompiled with CFR 0.152.
 */
package dmg.util.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import com.google.common.base.Preconditions;
import dmg.util.logback.FilterThresholdSet;
import dmg.util.logback.LoggerName;
import java.util.Collection;
import java.util.Formatter;
import java.util.Objects;
import org.dcache.util.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterShell {
    private final FilterThresholdSet _thresholds;
    private final LoggerContext _context = (LoggerContext)LoggerFactory.getILoggerFactory();
    public static final String hh_log_ls = "[-a] [<appender>] [<logger>]";
    public static final String fh_log_ls = "Lists current log thresholds. Inherited thresholds are marked\nwith an asterix.";
    public static final String hh_log_set = "<appender> [<logger>] OFF|ERROR|WARN|INFO|DEBUG|TRACE|ALL";
    public static final String fh_log_set = "Sets the log level of <appender>.";
    public static final String hh_log_reset = "[-a] <appender> [<logger>]";
    public static final String fh_log_reset = "Resets the log level of <appender>. The log level for <appender>\nwill be inherited from the parent cell.";

    public FilterShell(FilterThresholdSet thresholds) {
        Objects.requireNonNull(thresholds);
        this._thresholds = thresholds;
    }

    private boolean isExistingLogger(LoggerName name) {
        for (ch.qos.logback.classic.Logger logger : this.getLoggers()) {
            if (!name.isNameOfLogger((Logger)logger)) continue;
            return true;
        }
        return false;
    }

    private Collection<ch.qos.logback.classic.Logger> getLoggers() {
        return this._context.getLoggerList();
    }

    public String ac_log_ls_$_0_2(Args args) {
        boolean all = args.hasOption("a");
        String appender = args.argv(0);
        String logger = args.argv(1);
        Formatter out = new Formatter();
        if (logger != null) {
            this.lsLogger(out, all, LoggerName.getInstance(logger), appender);
        } else if (appender != null) {
            this.lsAppender(out, all, appender);
        } else {
            this.ls(out, all);
        }
        return out.toString();
    }

    private void ls(Formatter out, boolean all) {
        for (String appender : this._thresholds.getAppenders()) {
            this.lsAppender(out, all, appender);
        }
    }

    private void lsAppender(Formatter out, boolean all, String appender) {
        out.format("%s:\n", appender);
        for (ch.qos.logback.classic.Logger logger : this.getLoggers()) {
            this.lsLogger(out, all, LoggerName.getInstance((Logger)logger), appender);
        }
    }

    private void lsLogger(Formatter out, boolean all, LoggerName logger, String appender) {
        Level level = this._thresholds.get(logger, appender);
        if (level != null) {
            out.format("  %s=%s\n", logger, level);
        } else {
            level = this._thresholds.getInheritedMap(logger).get(appender);
            if (level != null) {
                out.format("  %s=%s*\n", logger, level);
            } else if (all) {
                out.format("  %s\n", logger);
            }
        }
    }

    public String ac_log_set_$_2_3(Args args) {
        String threshold;
        LoggerName logger;
        String appender = args.argv(0);
        if (args.argc() == 3) {
            logger = LoggerName.getInstance(args.argv(1));
            threshold = args.argv(2);
        } else {
            logger = LoggerName.ROOT;
            threshold = args.argv(1);
        }
        Preconditions.checkArgument((boolean)this._thresholds.hasAppender(appender), (Object)"Appender not found");
        Preconditions.checkArgument((boolean)this.isExistingLogger(logger), (Object)"Logger not found");
        Preconditions.checkArgument((Level.toLevel((String)threshold, null) != null ? 1 : 0) != 0, (Object)("Invalid log level: " + threshold));
        this._thresholds.setThreshold(logger, appender, Level.valueOf((String)threshold));
        return "";
    }

    public String ac_log_reset_$_1_2(Args args) {
        String appender = args.argv(0);
        if (args.argc() == 2) {
            this._thresholds.remove(LoggerName.getInstance(args.argv(1)), appender);
        } else if (!args.hasOption("a")) {
            this._thresholds.remove(LoggerName.ROOT, appender);
        } else {
            for (ch.qos.logback.classic.Logger logger : this.getLoggers()) {
                this._thresholds.remove(LoggerName.getInstance((Logger)logger), appender);
            }
        }
        return "";
    }
}

