/*
 * Decompiled with CFR 0.152.
 */
package dmg.util.logback;

import ch.qos.logback.classic.Level;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import dmg.util.logback.LoggerName;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;

public class FilterThresholdSet {
    private final FilterThresholdSet _parent;
    private final Set<String> _appenders = Sets.newHashSet();
    private final Set<LoggerName> _roots = new HashSet<LoggerName>();
    private final Table<LoggerName, String, Level> _rules = HashBasedTable.create();
    private final LoadingCache<String, Map<String, Level>> _effectiveMaps = CacheBuilder.newBuilder().build(CacheLoader.from(logger -> this.computeEffectiveMap(LoggerName.getInstance(logger))));
    private final LoadingCache<Logger, Optional<Level>> _effectiveLevels = CacheBuilder.newBuilder().build(CacheLoader.from(logger -> {
        try {
            Map map = (Map)this._effectiveMaps.get((Object)logger.getName());
            return map.isEmpty() ? Optional.empty() : Optional.of(Collections.min(map.values(), LEVEL_ORDER));
        }
        catch (ExecutionException e) {
            Throwables.throwIfUnchecked((Throwable)e.getCause());
            throw new RuntimeException(e.getCause());
        }
    }));
    private static final Comparator<Level> LEVEL_ORDER = (o1, o2) -> Integer.compare(o1.toInt(), o2.toInt());

    public FilterThresholdSet() {
        this(null);
    }

    public FilterThresholdSet(FilterThresholdSet parent) {
        this._parent = parent;
    }

    public synchronized void addAppender(String name) {
        Objects.requireNonNull(name);
        this._appenders.add(name);
    }

    public synchronized Collection<String> getAppenders() {
        if (this._parent == null) {
            return Lists.newArrayList(this._appenders);
        }
        Collection<String> appenders = this._parent.getAppenders();
        appenders.addAll(this._appenders);
        return appenders;
    }

    public synchronized boolean hasAppender(String appender) {
        return this._appenders.contains(appender) || this._parent != null && this._parent.hasAppender(appender);
    }

    public synchronized Level get(LoggerName logger, String appender) {
        return (Level)this._rules.get((Object)logger, (Object)appender);
    }

    public synchronized void setThreshold(LoggerName logger, String appender, Level level) {
        Objects.requireNonNull(logger);
        Objects.requireNonNull(level);
        Preconditions.checkArgument((boolean)this.hasAppender(appender));
        this._rules.put((Object)logger, (Object)appender, (Object)level);
        this.clearCache();
    }

    public synchronized boolean isRoot(LoggerName logger) {
        return this._parent != null && this._parent.isRoot(logger) || this._roots.contains(logger);
    }

    public synchronized void setRoot(LoggerName logger, boolean isRoot) {
        if (isRoot) {
            this._roots.add(logger);
        } else {
            this._roots.remove(logger);
        }
        this.clearCache();
    }

    public synchronized void remove(LoggerName logger, String appender) {
        if (this._rules.remove((Object)logger, (Object)appender) != null) {
            this.clearCache();
        }
    }

    public synchronized void clear() {
        this._rules.clear();
        this.clearCache();
    }

    private void clearCache() {
        this._effectiveMaps.invalidateAll();
        this._effectiveLevels.invalidateAll();
    }

    public synchronized Map<String, Level> getInheritedMap(LoggerName logger) {
        if (this._parent == null) {
            return Maps.newHashMap((Map)this._rules.row((Object)logger));
        }
        Map<String, Level> map = this._parent.getInheritedMap(logger);
        map.putAll(this._rules.row((Object)logger));
        return map;
    }

    private synchronized Map<String, Level> computeEffectiveMap(LoggerName logger) {
        LoggerName parent;
        Map<String, Level> inheritedMap = this.getInheritedMap(logger);
        if (!this.isRoot(logger) && (parent = logger.getParent()) != null) {
            Map<String, Level> mergedMap = this.computeEffectiveMap(parent);
            mergedMap.putAll(inheritedMap);
            return mergedMap;
        }
        return inheritedMap;
    }

    public Level getThreshold(LoggerName logger, String appender) {
        return this.getThreshold(logger.toString(), appender);
    }

    public Level getThreshold(String logger, String appender) {
        try {
            return (Level)((Map)this._effectiveMaps.get((Object)logger)).get(appender);
        }
        catch (ExecutionException e) {
            Throwables.throwIfUnchecked((Throwable)e.getCause());
            throw new RuntimeException(e.getCause());
        }
    }

    public Level getThreshold(Logger logger) {
        try {
            return ((Optional)this._effectiveLevels.get((Object)logger)).orElse(null);
        }
        catch (ExecutionException e) {
            Throwables.throwIfUnchecked((Throwable)e.getCause());
            throw new RuntimeException(e.getCause());
        }
    }
}

