/*
 * Decompiled with CFR 0.152.
 */
package dmg.util.logback;

import org.slf4j.Logger;

public class LoggerName {
    public static final LoggerName ROOT = new LoggerName("ROOT");
    private String _name;

    public static LoggerName getInstance(Logger logger) {
        return LoggerName.getInstance(logger.getName());
    }

    public static LoggerName getInstance(String name) {
        if (name.equalsIgnoreCase("ROOT")) {
            return ROOT;
        }
        return new LoggerName(name);
    }

    public static LoggerName valueOf(String name) {
        return LoggerName.getInstance(name);
    }

    private LoggerName(String name) {
        this._name = name;
    }

    public boolean isNameOfLogger(Logger logger) {
        return logger.getName().equals(this._name);
    }

    public String toString() {
        return this._name;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || that.getClass() != this.getClass()) {
            return false;
        }
        LoggerName other = (LoggerName)that;
        return this._name.equals(other._name);
    }

    public int hashCode() {
        return this._name.hashCode();
    }

    public LoggerName getParent() {
        if (this == ROOT) {
            return null;
        }
        int pos = Math.max(this._name.lastIndexOf(46), this._name.lastIndexOf(36));
        if (pos > -1) {
            return new LoggerName(this._name.substring(0, pos));
        }
        return ROOT;
    }
}

