/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.net.HostAndPort;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import javax.cache.Cache;
import javax.cache.Caching;
import javax.security.auth.Subject;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.utils.ZKPaths;
import org.apache.zookeeper.CreateMode;
import org.dcache.nfs.ChimeraNFSException;
import org.dcache.nfs.IoChannelCache;
import org.dcache.nfs.Mirror;
import org.dcache.nfs.bep.SetSize;
import org.dcache.nfs.status.BadHandleException;
import org.dcache.nfs.status.BadStateidException;
import org.dcache.nfs.status.DelayException;
import org.dcache.nfs.status.NfsIoException;
import org.dcache.nfs.v4.AbstractNFSv4Operation;
import org.dcache.nfs.v4.CompoundContext;
import org.dcache.nfs.v4.NFSServerV41;
import org.dcache.nfs.v4.NFSv4OperationFactory;
import org.dcache.nfs.v4.NfsIdMapping;
import org.dcache.nfs.v4.OperationBIND_CONN_TO_SESSION;
import org.dcache.nfs.v4.OperationCREATE_SESSION;
import org.dcache.nfs.v4.OperationDESTROY_CLIENTID;
import org.dcache.nfs.v4.OperationDESTROY_SESSION;
import org.dcache.nfs.v4.OperationEXCHANGE_ID;
import org.dcache.nfs.v4.OperationGETATTR;
import org.dcache.nfs.v4.OperationILLEGAL;
import org.dcache.nfs.v4.OperationPUTFH;
import org.dcache.nfs.v4.OperationPUTROOTFH;
import org.dcache.nfs.v4.OperationRECLAIM_COMPLETE;
import org.dcache.nfs.v4.OperationSEQUENCE;
import org.dcache.nfs.v4.xdr.COMMIT4res;
import org.dcache.nfs.v4.xdr.COMMIT4resok;
import org.dcache.nfs.v4.xdr.READ4res;
import org.dcache.nfs.v4.xdr.READ4resok;
import org.dcache.nfs.v4.xdr.WRITE4res;
import org.dcache.nfs.v4.xdr.WRITE4resok;
import org.dcache.nfs.v4.xdr.count4;
import org.dcache.nfs.v4.xdr.nfs_argop4;
import org.dcache.nfs.v4.xdr.nfs_fh4;
import org.dcache.nfs.v4.xdr.nfs_resop4;
import org.dcache.nfs.v4.xdr.nfsace4;
import org.dcache.nfs.v4.xdr.stateid4;
import org.dcache.nfs.vfs.AclCheckable;
import org.dcache.nfs.vfs.DirectoryStream;
import org.dcache.nfs.vfs.FsStat;
import org.dcache.nfs.vfs.Inode;
import org.dcache.nfs.vfs.Stat;
import org.dcache.nfs.vfs.VirtualFileSystem;
import org.dcache.nfs.zk.ZkDataServer;
import org.dcache.oncrpc4j.rpc.OncRpcClient;
import org.dcache.oncrpc4j.rpc.OncRpcException;
import org.dcache.oncrpc4j.rpc.OncRpcProgram;
import org.dcache.oncrpc4j.rpc.OncRpcSvc;
import org.dcache.oncrpc4j.rpc.OncRpcSvcBuilder;
import org.dcache.oncrpc4j.rpc.RpcAuth;
import org.dcache.oncrpc4j.rpc.RpcAuthTypeNone;
import org.dcache.oncrpc4j.rpc.RpcCall;
import org.dcache.oncrpc4j.rpc.RpcDispatchable;
import org.dcache.oncrpc4j.xdr.XdrAble;
import org.dcache.oncrpc4j.xdr.XdrInt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataServer.class);
    private static final String PNFS_DS_ADDRESS = "PNFS_DS_ADDRESS";
    private CuratorFramework zkCurator;
    private int port;
    private InetSocketAddress[] localInetAddresses;
    private String zkNode;
    private OncRpcSvc svc;
    private NFSServerV41 nfs;
    private IoChannelCache fsc;
    private String idFile;
    private Cache<byte[], byte[]> mdsStateIdCache;
    private RpcCall bepClient;
    private final VirtualFileSystem VFS = new VirtualFileSystem(){

        public int access(Inode inode, int mode) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void commit(Inode inode, long offset, int count) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Inode create(Inode parent, Stat.Type type, String path, Subject subject, int mode) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public FsStat getFsStat() throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Inode getRootInode() throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Inode lookup(Inode parent, String path) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Inode link(Inode parent, Inode link, String path, Subject subject) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public DirectoryStream list(Inode inode, byte[] verifier, long cookie) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public byte[] directoryVerifier(Inode inode) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Inode mkdir(Inode parent, String path, Subject subject, int mode) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public boolean move(Inode src, String oldName, Inode dest, String newName) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Inode parentOf(Inode inode) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public int read(Inode inode, byte[] data, long offset, int count) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String readlink(Inode inode) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void remove(Inode parent, String path) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Inode symlink(Inode parent, String path, String link, Subject subject, int mode) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public VirtualFileSystem.WriteResult write(Inode inode, byte[] data, long offset, int count, VirtualFileSystem.StabilityLevel stabilityLevel) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Stat getattr(Inode inode) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void setattr(Inode inode, Stat stat) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public nfsace4[] getAcl(Inode inode) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void setAcl(Inode inode, nfsace4[] acl) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public boolean hasIOLayout(Inode inode) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public AclCheckable getAclCheckable() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public NfsIdMapping getIdMapper() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    };

    public void setPort(int port) {
        this.port = port;
    }

    public void setCuratorFramework(CuratorFramework curatorFramework) {
        this.zkCurator = curatorFramework;
    }

    public void init() throws Exception {
        this.localInetAddresses = this.getLocalAddresses(this.port);
        this.nfs = new NFSServerV41.Builder().withOperationFactory((NFSv4OperationFactory)new EDSNFSv4OperationFactory()).withVfs(this.VFS).build();
        this.svc = new OncRpcSvcBuilder().withPort(this.port).withTCP().withoutAutoPublish().withRpcService(new OncRpcProgram(100003, 4), (RpcDispatchable)this.nfs).build();
        this.svc.start();
        long myId = ZkDataServer.getOrAllocateId(this.zkCurator, this.idFile);
        Mirror mirror = new Mirror(myId, this.localInetAddresses);
        this.zkNode = (String)((ACLBackgroundPathAndBytesable)this.zkCurator.create().creatingParentContainersIfNeeded().withMode(CreateMode.EPHEMERAL)).forPath(ZKPaths.makePath((String)"/nfs/pnfs", (String)("ds-" + myId)), ZkDataServer.toBytes(mirror));
        this.mdsStateIdCache = Caching.getCachingProvider().getCacheManager().getCache("open-stateid", byte[].class, byte[].class);
    }

    public void setIoChannelCache(IoChannelCache fsCache) {
        this.fsc = fsCache;
    }

    public void setIdFile(String path) {
        this.idFile = path;
    }

    public void destroy() throws Exception {
        this.svc.stop();
        this.zkCurator.delete().forPath(this.zkNode);
    }

    private InetSocketAddress[] getLocalAddresses(int port) throws SocketException {
        ArrayList<InetSocketAddress> localaddresses = new ArrayList<InetSocketAddress>();
        String suppliedAddress = System.getProperty(PNFS_DS_ADDRESS);
        if (Strings.isNullOrEmpty((String)suppliedAddress)) {
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                NetworkInterface iface = ifaces.nextElement();
                if (!iface.isUp() || iface.getName().startsWith("br-")) continue;
                Enumeration<InetAddress> addrs = iface.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    InetAddress addr = addrs.nextElement();
                    localaddresses.add(new InetSocketAddress(addr, port));
                }
            }
            return localaddresses.toArray(new InetSocketAddress[0]);
        }
        return (InetSocketAddress[])Splitter.on((char)',').trimResults().omitEmptyStrings().splitToList((CharSequence)suppliedAddress).stream().map(HostAndPort::fromString).map(s -> new InetSocketAddress(s.getHost(), s.getPort())).toArray(InetSocketAddress[]::new);
    }

    private RpcCall getBepClient() throws DelayException {
        if (this.bepClient == null || !this.bepClient.getTransport().isOpen()) {
            try {
                this.bepClient = new RpcCall(170001, 1, (RpcAuth)new RpcAuthTypeNone(), new OncRpcClient(InetAddress.getByName("mds"), 6, 2049).connect());
            }
            catch (IOException e) {
                throw new DelayException("fales to get BEP client", (Throwable)e);
            }
        }
        return this.bepClient;
    }

    private class DSOperationCOMMIT
    extends AbstractNFSv4Operation {
        public DSOperationCOMMIT(nfs_argop4 args) {
            super(args, 5);
        }

        public void process(CompoundContext context, nfs_resop4 result) throws ChimeraNFSException, IOException, OncRpcException {
            COMMIT4res res = result.opcommit;
            Inode inode = context.currentInode();
            RandomAccessFile out = DataServer.this.fsc.get(inode);
            SetSize ss = new SetSize(new nfs_fh4(inode.toNfsHandle()), out.length());
            XdrInt ssRes = new XdrInt();
            RpcCall r = DataServer.this.getBepClient();
            r.call(1, (XdrAble)ss, (XdrAble)ssRes);
            res.status = ssRes.intValue();
            if (res.status == 0) {
                res.resok4 = new COMMIT4resok();
                res.resok4.writeverf = context.getRebootVerifier();
            }
        }
    }

    private class DSOperationREAD
    extends AbstractNFSv4Operation {
        public DSOperationREAD(nfs_argop4 args) {
            super(args, 25);
        }

        public void process(CompoundContext context, nfs_resop4 result) throws ChimeraNFSException, IOException {
            READ4res res = result.opread;
            Inode inode = context.currentInode();
            stateid4 stateid = this._args.opread.stateid;
            byte[] fh = (byte[])DataServer.this.mdsStateIdCache.get((Object)stateid.other);
            if (fh == null) {
                throw new BadStateidException();
            }
            if (!Arrays.equals(fh, inode.toNfsHandle())) {
                throw new BadHandleException();
            }
            boolean eof = false;
            long offset = this._args.opread.offset.value;
            int count = this._args.opread.count.value;
            ByteBuffer bb = ByteBuffer.allocateDirect(count);
            FileChannel in = DataServer.this.fsc.get(inode).getChannel();
            int bytesReaded = in.read(bb, offset);
            if (bytesReaded < 0) {
                eof = true;
            }
            res.status = 0;
            res.resok4 = new READ4resok();
            res.resok4.data = bb;
            res.resok4.eof = eof;
        }
    }

    private class DSOperationWRITE
    extends AbstractNFSv4Operation {
        public DSOperationWRITE(nfs_argop4 args) {
            super(args, 38);
        }

        public void process(CompoundContext context, nfs_resop4 result) throws IOException {
            WRITE4res res = result.opwrite;
            long offset = this._args.opwrite.offset.value;
            this._args.opwrite.offset.checkOverflow(this._args.opwrite.data.remaining(), "offset + length overflow");
            Inode inode = context.currentInode();
            stateid4 stateid = this._args.opwrite.stateid;
            byte[] fh = (byte[])DataServer.this.mdsStateIdCache.get((Object)stateid.other);
            if (fh == null) {
                throw new BadStateidException();
            }
            if (!Arrays.equals(fh, inode.toNfsHandle())) {
                throw new BadHandleException();
            }
            FileChannel out = DataServer.this.fsc.get(inode).getChannel();
            this._args.opwrite.data.rewind();
            int bytesWritten = out.write(this._args.opwrite.data, offset);
            if (bytesWritten < 0) {
                throw new NfsIoException("IO not allowd");
            }
            res.status = 0;
            res.resok4 = new WRITE4resok();
            res.resok4.count = new count4(bytesWritten);
            res.resok4.committed = 0;
            res.resok4.writeverf = context.getRebootVerifier();
        }
    }

    private class EDSNFSv4OperationFactory
    implements NFSv4OperationFactory {
        private EDSNFSv4OperationFactory() {
        }

        public AbstractNFSv4Operation getOperation(nfs_argop4 op) {
            switch (op.argop) {
                case 5: {
                    return new DSOperationCOMMIT(op);
                }
                case 9: {
                    return new OperationGETATTR(op);
                }
                case 22: {
                    return new OperationPUTFH(op);
                }
                case 24: {
                    return new OperationPUTROOTFH(op);
                }
                case 25: {
                    return new DSOperationREAD(op);
                }
                case 38: {
                    return new DSOperationWRITE(op);
                }
                case 42: {
                    return new OperationEXCHANGE_ID(op);
                }
                case 43: {
                    return new OperationCREATE_SESSION(op);
                }
                case 44: {
                    return new OperationDESTROY_SESSION(op);
                }
                case 53: {
                    return new OperationSEQUENCE(op);
                }
                case 58: {
                    return new OperationRECLAIM_COMPLETE(op);
                }
                case 41: {
                    return new OperationBIND_CONN_TO_SESSION(op);
                }
                case 57: {
                    return new OperationDESTROY_CLIENTID(op);
                }
            }
            return new OperationILLEGAL(op);
        }
    }
}

