/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs;

import com.google.common.io.BaseEncoding;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.cache.Cache;
import javax.cache.Caching;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.dcache.nfs.ChimeraNFSException;
import org.dcache.nfs.Mirror;
import org.dcache.nfs.chimera.ChimeraVfs;
import org.dcache.nfs.status.LayoutTryLaterException;
import org.dcache.nfs.status.NoEntException;
import org.dcache.nfs.status.ServerFaultException;
import org.dcache.nfs.status.UnknownLayoutTypeException;
import org.dcache.nfs.v4.CompoundContext;
import org.dcache.nfs.v4.FlexFileLayoutDriver;
import org.dcache.nfs.v4.Layout;
import org.dcache.nfs.v4.LayoutDriver;
import org.dcache.nfs.v4.NFS4Client;
import org.dcache.nfs.v4.NFS4State;
import org.dcache.nfs.v4.NFSv41DeviceManager;
import org.dcache.nfs.v4.NfsV41FileLayoutDriver;
import org.dcache.nfs.v4.ff.ff_ioerr4;
import org.dcache.nfs.v4.ff.ff_iostats4;
import org.dcache.nfs.v4.ff.ff_layoutreturn4;
import org.dcache.nfs.v4.xdr.device_addr4;
import org.dcache.nfs.v4.xdr.deviceid4;
import org.dcache.nfs.v4.xdr.layout4;
import org.dcache.nfs.v4.xdr.layouttype4;
import org.dcache.nfs.v4.xdr.length4;
import org.dcache.nfs.v4.xdr.nfs_fh4;
import org.dcache.nfs.v4.xdr.offset4;
import org.dcache.nfs.v4.xdr.stateid4;
import org.dcache.nfs.v4.xdr.utf8str_mixed;
import org.dcache.nfs.vfs.Inode;
import org.dcache.nfs.zk.ZkDataServer;
import org.dcache.oncrpc4j.util.Bytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.core.KafkaTemplate;

public class DeviceManager
implements NFSv41DeviceManager {
    private static final Logger _log = LoggerFactory.getLogger(DeviceManager.class);
    private final Map<deviceid4, InetSocketAddress[]> _deviceMap = new ConcurrentHashMap<deviceid4, InetSocketAddress[]>();
    private final Map<stateid4, NFS4State> _openToLayoutStateid = new ConcurrentHashMap<stateid4, NFS4State>();
    private CuratorFramework zkCurator;
    private PathChildrenCache dsNodeCache;
    private final Map<layouttype4, LayoutDriver> _supportedDrivers = new EnumMap<layouttype4, LayoutDriver>(layouttype4.class);
    private Cache<byte[], byte[]> mdsStateIdCache;
    private KafkaTemplate<Object, ff_iostats4> iostatKafkaTemplate;
    private KafkaTemplate<Object, ff_ioerr4> ioerrKafkaTemplate;
    private ChimeraVfs fs;

    public void setChimeraVfs(ChimeraVfs fs) {
        this.fs = fs;
    }

    public void setCuratorFramework(CuratorFramework curatorFramework) {
        this.zkCurator = curatorFramework;
    }

    public void init() throws Exception {
        Consumer<ff_layoutreturn4> flexfilesStat = lr -> {
            for (ff_iostats4 ff_iostats42 : lr.fflr_iostats_report) {
                this.iostatKafkaTemplate.sendDefault((Object)ff_iostats42);
            }
            for (ff_iostats4 ff_iostats43 : lr.fflr_ioerr_report) {
                this.ioerrKafkaTemplate.sendDefault((Object)ff_iostats43);
            }
        };
        this._supportedDrivers.put(layouttype4.LAYOUT4_FLEX_FILES, (LayoutDriver)new FlexFileLayoutDriver(4, 1, new utf8str_mixed("17"), new utf8str_mixed("17"), flexfilesStat));
        this._supportedDrivers.put(layouttype4.LAYOUT4_NFSV4_1_FILES, (LayoutDriver)new NfsV41FileLayoutDriver());
        this.mdsStateIdCache = Caching.getCachingProvider().getCacheManager().getCache("open-stateid", byte[].class, byte[].class);
        this.dsNodeCache = new PathChildrenCache(this.zkCurator, "/nfs/pnfs", true);
        this.dsNodeCache.getListenable().addListener((c, e) -> {
            switch (e.getType()) {
                case CHILD_ADDED: 
                case CHILD_UPDATED: {
                    _log.info("Adding DS: {}", (Object)e.getData().getPath());
                    this.addDS(e.getData().getPath());
                    break;
                }
                case CHILD_REMOVED: {
                    _log.info("Removing DS: {}", (Object)e.getData().getPath());
                    this.removeDS(e.getData().getPath());
                }
            }
        });
        this.dsNodeCache.start();
    }

    public Layout layoutGet(CompoundContext context, Inode inode, layouttype4 layoutType, int ioMode, stateid4 stateid) throws IOException {
        NFS4Client client = context.getSession().getClient();
        NFS4State nfsState = client.state(stateid);
        LayoutDriver layoutDriver = this.getLayoutDriver(layoutType);
        deviceid4[] deviceId = this.getOrBindDeviceId(inode, ioMode, layoutType);
        NFS4State openState = nfsState.getOpenState();
        stateid4 rawOpenState = openState.stateid();
        NFS4State layoutStateId = this._openToLayoutStateid.get(rawOpenState);
        if (layoutStateId == null) {
            layoutStateId = client.createState(openState.getStateOwner(), openState);
            this._openToLayoutStateid.put(stateid, layoutStateId);
            this.mdsStateIdCache.put((Object)rawOpenState.other, (Object)context.currentInode().toNfsHandle());
            nfsState.addDisposeListener(state -> {
                this._openToLayoutStateid.remove(rawOpenState);
                this.mdsStateIdCache.remove((Object)rawOpenState.other);
            });
        } else {
            layoutStateId.bumpSeqid();
        }
        nfs_fh4 fh = new nfs_fh4(context.currentInode().toNfsHandle());
        layout4 layout = new layout4();
        layout.lo_iomode = ioMode;
        layout.lo_offset = new offset4(0L);
        layout.lo_length = new length4(-1L);
        layout.lo_content = layoutDriver.getLayoutContent(stateid, 0x400000, fh, deviceId);
        return new Layout(true, layoutStateId.stateid(), new layout4[]{layout});
    }

    public device_addr4 getDeviceInfo(CompoundContext context, deviceid4 deviceId, layouttype4 layoutType) throws ChimeraNFSException {
        _log.debug("lookup for device: {}, type: {}", (Object)deviceId, (Object)layoutType);
        InetSocketAddress[] addrs = this._deviceMap.get(deviceId);
        if (addrs == null) {
            throw new NoEntException("Unknown device id: " + deviceId);
        }
        InetAddress clientAddress = context.getRemoteSocketAddress().getAddress();
        InetSocketAddress[] effectiveAddresses = (InetSocketAddress[])Stream.of(addrs).filter(a -> !a.getAddress().isLoopbackAddress() || clientAddress.isLoopbackAddress()).filter(a -> !a.getAddress().isLinkLocalAddress() || clientAddress.isLinkLocalAddress()).filter(a -> !a.getAddress().isSiteLocalAddress() || clientAddress.isSiteLocalAddress()).toArray(InetSocketAddress[]::new);
        LayoutDriver layoutDriver = this.getLayoutDriver(layoutType);
        return layoutDriver.getDeviceAddress(effectiveAddresses);
    }

    public List<deviceid4> getDeviceList(CompoundContext context) {
        return new ArrayList<deviceid4>(this._deviceMap.keySet());
    }

    public void layoutReturn(CompoundContext context, stateid4 stateid, layouttype4 layoutType, byte[] body) throws ChimeraNFSException {
        _log.debug("release device for stateid {}", (Object)stateid);
        NFS4Client client = context.getSession().getClient();
        NFS4State layoutState = client.state(stateid);
        this._openToLayoutStateid.remove(layoutState.getOpenState().stateid());
        this.getLayoutDriver(layoutType).acceptLayoutReturnData(body);
    }

    private LayoutDriver getLayoutDriver(layouttype4 layoutType) throws UnknownLayoutTypeException {
        LayoutDriver layoutDriver = this._supportedDrivers.get(layoutType);
        if (layoutDriver == null) {
            throw new UnknownLayoutTypeException("Unsupported Layout type: " + layoutType);
        }
        return layoutDriver;
    }

    public Set<layouttype4> getLayoutTypes() {
        return this._supportedDrivers.keySet();
    }

    private static deviceid4 deviceidOf(long id) {
        byte[] deviceidBytes = new byte[16];
        Bytes.putLong((byte[])deviceidBytes, (int)0, (long)id);
        return new deviceid4(deviceidBytes);
    }

    private void addDS(String node) throws Exception {
        byte[] data = (byte[])this.zkCurator.getData().forPath(node);
        Mirror mirror = ZkDataServer.stringToString(data);
        this._deviceMap.put(DeviceManager.deviceidOf(mirror.getId()), mirror.getMultipath());
    }

    private void removeDS(String node) throws Exception {
        String id = node.substring("ds-".length() + "/nfs/pnfs".length() + 1);
        int deviceId = Integer.parseInt(id);
        this._deviceMap.remove(DeviceManager.deviceidOf(deviceId));
    }

    public void setIoStatKafkaTemplate(KafkaTemplate<Object, ff_iostats4> template) {
        this.iostatKafkaTemplate = template;
    }

    public void setIoErrKafkaTemplate(KafkaTemplate<Object, ff_ioerr4> template) {
        this.ioerrKafkaTemplate = template;
    }

    private deviceid4[] getOrBindDeviceId(Inode inode, int iomode, layouttype4 layoutType) throws ChimeraNFSException, IOException {
        deviceid4[] deviceId;
        String combinedLocation = this.fs.getInodeLayout(inode);
        if (combinedLocation != null) {
            byte[] raw = BaseEncoding.base16().lowerCase().decode((CharSequence)combinedLocation);
            if (raw.length == 0 || raw.length % 2 != 0) {
                throw new ServerFaultException("invalid location size");
            }
            ByteBuffer b = ByteBuffer.wrap(raw);
            deviceId = new deviceid4[raw.length / 2];
            for (int i = 0; i < deviceId.length; ++i) {
                deviceId[i] = DeviceManager.deviceidOf(b.getShort(i));
            }
        } else {
            if (iomode == 1) {
                throw new LayoutTryLaterException("No location");
            }
            int mirrors = layoutType == layouttype4.LAYOUT4_FLEX_FILES ? 2 : 1;
            ByteBuffer b = ByteBuffer.allocate(2 * mirrors);
            deviceId = (deviceid4[])((Stream)this._deviceMap.keySet().stream().unordered()).limit(mirrors).peek(d -> b.putShort((short)Bytes.getInt((byte[])d.value, (int)0))).toArray(deviceid4[]::new);
            if (deviceId.length == 0) {
                throw new LayoutTryLaterException("No dataservers available");
            }
            if (!this.fs.setInodeLayout(inode, BaseEncoding.base16().lowerCase().encode(b.array()))) {
                return this.getOrBindDeviceId(inode, iomode, layoutType);
            }
        }
        return deviceId;
    }
}

