/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs;

import java.security.Principal;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.dcache.auth.GidPrincipal;
import org.dcache.auth.UidPrincipal;
import org.dcache.oncrpc4j.rpc.RpcLoginService;
import org.dcache.oncrpc4j.rpc.RpcTransport;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcGssLogin
implements RpcLoginService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RpcGssLogin.class);

    public Subject login(RpcTransport transport, GSSContext gssContext) {
        Subject s = new Subject();
        s.getPrincipals().add((Principal)new UidPrincipal(10006L));
        s.getPrincipals().add((Principal)new GidPrincipal(1000L, true));
        try {
            s.getPrincipals().add(new KerberosPrincipal(gssContext.getSrcName().toString()));
        }
        catch (GSSException e) {
            LOGGER.warn("Failed to get source pringipal: ", (Object)e.getMessage());
        }
        return s;
    }
}

