/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.zk;

import com.google.common.base.Throwables;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.atomic.AtomicValue;
import org.apache.curator.framework.recipes.atomic.DistributedAtomicLong;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.dcache.nfs.Mirror;
import org.dcache.oncrpc4j.rpc.net.InetSocketAddresses;
import org.dcache.oncrpc4j.util.Bytes;
import org.json.JSONArray;
import org.json.JSONObject;

public class ZkDataServer {
    private static final String zkSequencePath = "/nfs/next-ds-id";

    public static byte[] toBytes(Mirror mirror) {
        JSONObject o = new JSONObject();
        o.put("version", (Object)"1.0");
        JSONArray a = new JSONArray();
        for (InetSocketAddress addr : mirror.getMultipath()) {
            a.put((Object)InetSocketAddresses.uaddrOf((InetSocketAddress)addr));
        }
        o.put("address", (Object)a);
        o.put("deviceid", mirror.getId());
        return o.toString().getBytes(StandardCharsets.UTF_8);
    }

    public static Mirror stringToString(byte[] bytes) {
        JSONObject o = new JSONObject(new String(bytes, StandardCharsets.UTF_8));
        JSONArray a = o.getJSONArray("address");
        long id = o.getLong("deviceid");
        InetSocketAddress[] addrs = new InetSocketAddress[a.length()];
        for (int i = 0; i < addrs.length; ++i) {
            addrs[i] = InetSocketAddresses.forUaddrString((String)a.getString(i));
        }
        return new Mirror(id, addrs);
    }

    public static long getOrAllocateId(CuratorFramework curator, String idFile) throws IOException {
        Path p = new File(idFile).toPath();
        if (Files.isRegularFile(p, new LinkOption[0])) {
            byte[] b = Files.readAllBytes(p);
            if (b.length > 8) {
                return Bytes.getLong((byte[])b, (int)0);
            }
        } else if (Files.exists(p, new LinkOption[0])) {
            throw new FileAlreadyExistsException("Path existis and not a regular file");
        }
        try {
            AtomicValue v;
            DistributedAtomicLong dal = new DistributedAtomicLong(curator, zkSequencePath, (RetryPolicy)new ExponentialBackoffRetry(1000, Integer.MAX_VALUE));
            while (!(v = dal.increment()).succeeded()) {
            }
            byte[] b = new byte[8];
            long id = (Long)v.postValue();
            Bytes.putLong((byte[])b, (int)0, (long)id);
            Files.write(p, b, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE, StandardOpenOption.DSYNC);
            return id;
        }
        catch (Exception e) {
            Throwables.throwIfInstanceOf((Throwable)e, IOException.class);
            throw new IOException(e);
        }
    }
}

