/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.dcache.chimera.DirectoryStreamB;
import org.dcache.chimera.FsInode;
import org.dcache.chimera.HimeraDirectoryEntry;
import org.dcache.chimera.IOHimeraFsException;

public class DirectoryStreamHelper {
    public static List<HimeraDirectoryEntry> listOf(FsInode inode) throws IOException, IOHimeraFsException {
        int estimatedListSize = inode.statCache().getNlink();
        if (estimatedListSize < 0) {
            throw new RuntimeException("Invalid nlink count for directory: " + inode);
        }
        ArrayList<HimeraDirectoryEntry> directoryList = new ArrayList<HimeraDirectoryEntry>(estimatedListSize);
        try (DirectoryStreamB<HimeraDirectoryEntry> dirStream = inode.newDirectoryStream();){
            for (HimeraDirectoryEntry e : dirStream) {
                directoryList.add(e);
            }
        }
        return directoryList;
    }
}

