/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.dcache.chimera.FileSystemProvider;
import org.dcache.chimera.JdbcFs;

public class FsFactory {
    public static final String USAGE = "<jdbcUrl> <dbDialect> <dbUser> <dbPass>";
    public static final int ARGC = 4;

    public static FileSystemProvider createFileSystem(String[] args) {
        if (args.length < 4) {
            throw new IllegalArgumentException("Required argument missing: <jdbcUrl> <dbDialect> <dbUser> <dbPass>");
        }
        return FsFactory.getFileSystemProvider(args[0], args[2], args[3], args[1]);
    }

    public static FileSystemProvider getFileSystemProvider(String url, String user, String pass, String dialect) {
        HikariConfig config = new HikariConfig();
        config.setDataSource((DataSource)new DriverManagerDataSource(url, user, pass));
        config.setMaximumPoolSize(3);
        config.setMinimumIdle(0);
        return new JdbcFs((DataSource)new HikariDataSource(config), dialect);
    }

    private static class DriverManagerDataSource
    implements DataSource {
        private final String url;
        private final String user;
        private final String pass;

        public DriverManagerDataSource(String url, String user, String pass) {
            this.url = url;
            this.user = user;
            this.pass = pass;
        }

        @Override
        public Connection getConnection() throws SQLException {
            return this.getConnection(this.user, this.pass);
        }

        @Override
        public Connection getConnection(String username, String password) throws SQLException {
            return DriverManager.getConnection(this.url, username, password);
        }

        @Override
        public PrintWriter getLogWriter() throws SQLException {
            throw new UnsupportedOperationException("getLogWriter");
        }

        @Override
        public void setLogWriter(PrintWriter out) throws SQLException {
            throw new UnsupportedOperationException("setLogWriter");
        }

        @Override
        public void setLoginTimeout(int seconds) throws SQLException {
            throw new UnsupportedOperationException("setLoginTimeout");
        }

        @Override
        public int getLoginTimeout() throws SQLException {
            return 0;
        }

        @Override
        public Logger getParentLogger() throws SQLFeatureNotSupportedException {
            throw new SQLFeatureNotSupportedException("getParentLogger");
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            if (iface.isInstance(this)) {
                return (T)this;
            }
            throw new SQLException("DataSource of type [" + this.getClass().getName() + "] cannot be unwrapped as [" + iface.getName() + "]");
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            return iface.isInstance(this);
        }
    }
}

