/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera;

import org.dcache.chimera.ChimeraFsException;
import org.dcache.chimera.FileNotFoundHimeraFsException;
import org.dcache.chimera.FileSystemProvider;
import org.dcache.chimera.FsInode;
import org.dcache.chimera.FsInodeType;
import org.dcache.chimera.posix.Stat;

public class FsInode_PARENT
extends FsInode {
    String _parent;

    public FsInode_PARENT(FileSystemProvider fs, String id) {
        super(fs, id, FsInodeType.PARENT);
    }

    @Override
    public int read(long pos, byte[] data, int offset, int len) {
        int rc = -1;
        if (this._parent == null) {
            try {
                this._parent = this._fs.getParentOf(this).toString();
            }
            catch (ChimeraFsException e) {
                return -1;
            }
        }
        if (!this._parent.equals(this.toString())) {
            byte[] b = (this._parent + "\n").getBytes();
            if (pos > (long)b.length) {
                return 0;
            }
            int copyLen = Math.min(len, b.length - (int)pos);
            System.arraycopy(b, (int)pos, data, 0, copyLen);
            rc = copyLen;
        }
        return rc;
    }

    @Override
    public Stat stat() throws ChimeraFsException {
        Stat ret = super.stat();
        ret.setMode(ret.getMode() & 0x1FF | 0x8000);
        if (this._parent == null) {
            FsInode parentInode = this._fs.getParentOf(this);
            if (parentInode == null) {
                throw new FileNotFoundHimeraFsException();
            }
            this._parent = parentInode.toString();
        }
        if (this._parent.equals(this.toString())) {
            throw new ChimeraFsException("Parent and child equil");
        }
        ret.setSize(this._parent.length() + 1);
        return ret;
    }

    @Override
    public int write(long pos, byte[] data, int offset, int len) {
        return -1;
    }
}

