/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera;

import java.util.Iterator;
import java.util.Set;
import org.dcache.chimera.ChimeraFsException;
import org.dcache.chimera.FileSystemProvider;
import org.dcache.chimera.FsInodeType;
import org.dcache.chimera.FsInode_PGET;
import org.dcache.util.Checksum;

public class FsInode_PCRC
extends FsInode_PGET {
    private String _checksum;

    public FsInode_PCRC(FileSystemProvider fs, String id) {
        super(fs, id, FsInodeType.PCRC);
    }

    @Override
    protected String value() throws ChimeraFsException {
        if (this._checksum == null) {
            Checksum result;
            Set<Checksum> results = this._fs.getInodeChecksums(this);
            StringBuilder sb = new StringBuilder();
            Iterator<Checksum> it = results.iterator();
            if (it.hasNext()) {
                result = it.next();
                sb.append(result.getType()).append(":").append(result.getValue());
            }
            while (it.hasNext()) {
                result = it.next();
                sb.append(", ").append(result.getType()).append(":").append(result.getValue());
            }
            sb.append("\n\r");
            this._checksum = sb.toString();
        }
        return this._checksum;
    }
}

