/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera;

import org.dcache.chimera.ChimeraFsException;
import org.dcache.chimera.FileSystemProvider;
import org.dcache.chimera.FsInode;
import org.dcache.chimera.FsInodeType;
import org.dcache.chimera.posix.Stat;

public abstract class FsInode_PGET
extends FsInode {
    protected static final String NEWLINE = "\n\r";

    protected FsInode_PGET(FileSystemProvider fs, String id, FsInodeType type) {
        super(fs, id, type);
    }

    @Override
    public int read(long pos, byte[] data, int offset, int len) {
        String value;
        try {
            value = this.value();
        }
        catch (ChimeraFsException e) {
            value = "";
        }
        byte[] b = value.getBytes();
        if (pos > (long)b.length) {
            return 0;
        }
        int copyLen = Math.min(len, b.length - (int)pos);
        System.arraycopy(b, (int)pos, data, 0, copyLen);
        return copyLen;
    }

    @Override
    public Stat stat() throws ChimeraFsException {
        Stat ret = super.stat();
        ret.setMode(ret.getMode() & 0x1FF | 0x8000);
        ret.setSize(this.value().length());
        ret.setMTime(System.currentTimeMillis());
        return ret;
    }

    @Override
    public int write(long pos, byte[] data, int offset, int len) {
        return -1;
    }

    protected abstract String value() throws ChimeraFsException;
}

