/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.dcache.chimera.ChimeraFsException;
import org.dcache.chimera.DirectoryStreamHelper;
import org.dcache.chimera.FileSystemProvider;
import org.dcache.chimera.FsInode;
import org.dcache.chimera.HimeraDirectoryEntry;

public class HFile
extends File {
    private static final long serialVersionUID = 6304886860060999115L;
    private FsInode _inode;
    private FsInode _parent;
    private final FileSystemProvider _fs;
    private boolean _isNew;

    public HFile(FileSystemProvider fs, String path) {
        super(path);
        this._fs = fs;
        try {
            this._inode = this._fs.path2inode(path);
        }
        catch (Exception e) {
            this._isNew = true;
        }
    }

    public HFile(HFile parent, String name) {
        super(parent, name);
        this._parent = parent.getInode();
        this._fs = parent.getInode().getFs();
        try {
            this._inode = this._fs.inodeOf(parent.getInode(), name);
        }
        catch (Exception e) {
            this._isNew = true;
        }
    }

    @Override
    public boolean exists() {
        return this._inode != null;
    }

    @Override
    public boolean isDirectory() {
        return this.exists() && this._inode.isDirectory();
    }

    @Override
    public boolean isFile() {
        return this.exists() && !this._inode.isDirectory();
    }

    @Override
    public String[] list() {
        try {
            List<HimeraDirectoryEntry> fullList = DirectoryStreamHelper.listOf(this._inode);
            String[] list = new String[fullList.size()];
            int i = 0;
            for (HimeraDirectoryEntry entry : fullList) {
                list[i++] = entry.getName();
            }
            return list;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public long length() {
        long size = 0L;
        try {
            if (this._inode != null) {
                size = this._inode.statCache().getSize();
            }
        }
        catch (ChimeraFsException chimeraFsException) {
            // empty catch block
        }
        return size;
    }

    @Override
    public long lastModified() {
        long mtime = 0L;
        try {
            if (this._inode != null) {
                mtime = this._inode.statCache().getMTime();
            }
        }
        catch (ChimeraFsException chimeraFsException) {
            // empty catch block
        }
        return mtime;
    }

    @Override
    public boolean createNewFile() throws IOException {
        boolean rc = false;
        if (this._isNew) {
            try {
                if (this._parent == null) {
                    this._parent = this._fs.path2inode(super.getParent());
                }
                this._inode = this._fs.createFile(this._parent, super.getName());
                rc = true;
            }
            catch (ChimeraFsException hfe) {
                throw new IOException(hfe.getMessage());
            }
        }
        return rc;
    }

    @Override
    public boolean mkdir() {
        boolean rc = false;
        if (this._isNew) {
            try {
                if (this._parent == null) {
                    this._parent = this._fs.path2inode(super.getParent());
                }
                this._inode = this._fs.mkdir(this._parent, super.getName());
                rc = true;
            }
            catch (ChimeraFsException chimeraFsException) {
                // empty catch block
            }
        }
        return rc;
    }

    @Override
    public boolean delete() {
        boolean rc = false;
        if (this.exists()) {
            try {
                this._fs.remove(this._inode);
            }
            catch (ChimeraFsException chimeraFsException) {
                // empty catch block
            }
        }
        return rc;
    }

    public FsInode getInode() {
        return this._inode;
    }

    public int write(byte[] data) {
        return this.write(0L, data, 0, data.length);
    }

    public int write(long pos, byte[] data, int offset, int len) {
        return this._inode.write(pos, data, offset, len);
    }

    public int read(byte[] data) {
        return this.read(0L, data, 0, data.length);
    }

    public int read(long pos, byte[] data, int offset, int len) {
        return this._inode.read(pos, data, offset, len);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof HFile)) {
            return false;
        }
        HFile o = (HFile)obj;
        return this._fs.equals(o._fs);
    }

    @Override
    public int hashCode() {
        return 17;
    }
}

