/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.cli;

import com.google.common.base.Strings;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import org.dcache.chimera.DirectoryStreamB;
import org.dcache.chimera.FileSystemProvider;
import org.dcache.chimera.FsFactory;
import org.dcache.chimera.FsInode;
import org.dcache.chimera.HimeraDirectoryEntry;
import org.dcache.chimera.UnixPermission;
import org.dcache.chimera.posix.Stat;

public class Ls {
    private static final int BLOCK_SIZE = 1024;
    private static final int[] INT_SIZE_TABLE = new int[]{9, 99, 999, 9999, 99999, 999999, 9999999, 99999999, 999999999, Integer.MAX_VALUE};
    private static final DateFormat WITH_YEAR = new SimpleDateFormat("MMM dd  yyyy");
    private static final DateFormat WITHOUT_YEAR = new SimpleDateFormat("MMM dd HH:mm");
    private static int nlinkWidth = 0;
    private static int uidWidth = 0;
    private static int gidWidth = 0;
    private static int sizeWidth = 0;
    private static final long sixMonthsInPast = Ls.sixMonthsInPast();
    private static final long oneHourInFuture = Ls.oneHourInFuture();

    public static void main(String[] args) throws Exception {
        if (args.length != 5) {
            System.err.println("Usage : " + Ls.class.getName() + " " + "<jdbcUrl> <dbDialect> <dbUser> <dbPass>" + " <chimera path>");
            System.exit(4);
        }
        LinkedList<HimeraDirectoryEntry> entries = new LinkedList<HimeraDirectoryEntry>();
        long totalBlocks = 0L;
        HimeraDirectoryEntry dot = null;
        HimeraDirectoryEntry dotdot = null;
        try (FileSystemProvider fs = FsFactory.createFileSystem(args);){
            FsInode inode = fs.path2inode(args[4]);
            try (DirectoryStreamB<HimeraDirectoryEntry> dirStream = inode.newDirectoryStream();){
                for (HimeraDirectoryEntry entry : dirStream) {
                    String name = entry.getName();
                    Stat stat = entry.getStat();
                    if (name.equals(".")) {
                        dot = entry;
                    } else if (name.equals("..")) {
                        dotdot = entry;
                    } else {
                        entries.add(entry);
                    }
                    totalBlocks = Ls.updateTotalBlocks(totalBlocks, stat);
                    nlinkWidth = Ls.updateMaxWidth(nlinkWidth, stat.getNlink());
                    uidWidth = Ls.updateMaxWidth(uidWidth, stat.getUid());
                    gidWidth = Ls.updateMaxWidth(gidWidth, stat.getGid());
                    sizeWidth = Ls.updateMaxWidth(sizeWidth, stat.getSize());
                }
            }
        }
        System.out.println("total " + totalBlocks);
        Ls.printEntry(dot);
        Ls.printEntry(dotdot);
        for (HimeraDirectoryEntry entry : entries) {
            Ls.printEntry(entry);
        }
    }

    private static void printEntry(HimeraDirectoryEntry entry) {
        if (entry != null) {
            Stat stat = entry.getStat();
            String s = String.format("%s %s %s %s %s %s %s", Ls.permissionsFor(stat), Ls.pad(stat.getNlink(), nlinkWidth), Ls.pad(stat.getUid(), uidWidth), Ls.pad(stat.getGid(), gidWidth), Ls.pad(stat.getSize(), sizeWidth), Ls.dateOf(stat.getMTime()), entry.getName());
            System.out.println(s);
        }
    }

    private static String dateOf(long time) {
        Date d = new Date(time);
        if (time < sixMonthsInPast || time > oneHourInFuture) {
            return WITH_YEAR.format(d);
        }
        return WITHOUT_YEAR.format(d);
    }

    private static long sixMonthsInPast() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -6);
        return calendar.getTimeInMillis();
    }

    private static long oneHourInFuture() {
        return System.currentTimeMillis() + TimeUnit.HOURS.toMillis(1L);
    }

    private static String pad(int value, int width) {
        String str = String.valueOf(value);
        return Strings.padStart((String)str, (int)width, (char)' ');
    }

    private static String pad(long value, int width) {
        String str = String.valueOf(value);
        return Strings.padStart((String)str, (int)width, (char)' ');
    }

    private static long updateTotalBlocks(long total, Stat stat) {
        long nBlocks = 1L + (stat.getSize() - 1L) / 1024L;
        return total + nBlocks;
    }

    private static int updateMaxWidth(int max, int value) {
        int width = Ls.widthOf(value);
        return width > max ? width : max;
    }

    private static int updateMaxWidth(int max, long value) {
        int width = Ls.widthOf(value);
        return width > max ? width : max;
    }

    private static String permissionsFor(Stat stat) {
        return new UnixPermission(stat.getMode()).toString();
    }

    private static int widthOf(int x) {
        int i = 0;
        while (x > INT_SIZE_TABLE[i]) {
            ++i;
        }
        return i + 1;
    }

    private static int widthOf(long x) {
        if (x <= Integer.MAX_VALUE) {
            return Ls.widthOf((int)x);
        }
        if (x < 1000000000000L) {
            if (x < 10000000000L) {
                return 10;
            }
            return x < 100000000000L ? 11 : 12;
        }
        if (x < 10000000000000000L) {
            if (x < 100000000000000L) {
                return x < 10000000000000L ? 13 : 14;
            }
            return x < 1000000000000000L ? 15 : 16;
        }
        if (x < 1000000000000000000L) {
            return x < 100000000000000000L ? 17 : 18;
        }
        return 19;
    }
}

