/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.cli;

import com.google.common.io.ByteStreams;
import java.io.InputStream;
import org.dcache.chimera.ChimeraFsException;
import org.dcache.chimera.FileNotFoundHimeraFsException;
import org.dcache.chimera.FileSystemProvider;
import org.dcache.chimera.FsFactory;
import org.dcache.chimera.FsInode;

public class Writedata {
    public static void main(String[] args) throws Exception {
        int programArgc = args.length - 4;
        if (programArgc < 1 || programArgc > 2) {
            System.err.println("Usage : " + Writedata.class.getName() + " " + "<jdbcUrl> <dbDialect> <dbUser> <dbPass>" + " <chimera path> [<data>]");
            System.exit(4);
        }
        try (FileSystemProvider fs = FsFactory.createFileSystem(args);){
            byte[] data = programArgc == 1 ? ByteStreams.toByteArray((InputStream)System.in) : Writedata.newLineTerminated(args[5]).getBytes();
            Writedata.writeDataIntoFile(fs, args[4], data);
        }
    }

    private static void writeDataIntoFile(FileSystemProvider fs, String filePath, byte[] data) throws ChimeraFsException {
        try {
            fs.stat(filePath);
        }
        catch (FileNotFoundHimeraFsException fnf) {
            fs.createFile(filePath);
        }
        FsInode inode = fs.path2inode(filePath);
        fs.setInodeIo(inode, true);
        inode.write(0L, data, 0, data.length);
    }

    private static String newLineTerminated(String unknown) {
        return unknown.endsWith("\n") ? unknown : unknown + "\n";
    }
}

