/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.cli;

import com.google.common.io.ByteStreams;
import java.io.InputStream;
import org.dcache.chimera.FileNotFoundHimeraFsException;
import org.dcache.chimera.FileSystemProvider;
import org.dcache.chimera.FsFactory;
import org.dcache.chimera.FsInode;

public class Writetag {
    public static void main(String[] args) throws Exception {
        int programArgc = args.length - 4;
        if (programArgc < 2 || programArgc > 3) {
            System.err.println("Usage : " + Writetag.class.getName() + " " + "<jdbcUrl> <dbDialect> <dbUser> <dbPass>" + " <chimera path> <tag> [<data>]");
            System.exit(4);
        }
        try (FileSystemProvider fs = FsFactory.createFileSystem(args);){
            byte[] data;
            FsInode inode = fs.path2inode(args[4]);
            String tag = args[5];
            try {
                fs.statTag(inode, tag);
            }
            catch (FileNotFoundHimeraFsException fnf) {
                fs.createTag(inode, tag);
            }
            byte[] byArray = data = programArgc == 2 ? ByteStreams.toByteArray((InputStream)System.in) : Writetag.newLineTerminated(args[6]).getBytes();
            if (data.length > 0) {
                fs.setTag(inode, tag, data, 0, data.length);
            }
        }
    }

    private static String newLineTerminated(String unknown) {
        return unknown.endsWith("\n") ? unknown : unknown + "\n";
    }
}

