/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.nfs.v4;

import java.util.List;
import org.dcache.chimera.nfs.ChimeraNFSException;
import org.dcache.chimera.nfs.v4.NFS4Client;
import org.dcache.chimera.nfs.v4.SessionSlot;
import org.dcache.chimera.nfs.v4.xdr.nfs_resop4;
import org.dcache.chimera.nfs.v4.xdr.sessionid4;
import org.dcache.utils.Bytes;

public class NFSv41Session {
    private final sessionid4 _session;
    private final SessionSlot[] _slots;
    private final NFS4Client _client;
    private final int _sequence;

    public NFSv41Session(NFS4Client client, int sequence, int replyCacheSize) {
        this._client = client;
        this._sequence = sequence;
        this._slots = new SessionSlot[replyCacheSize];
        byte[] id = new byte[16];
        Bytes.putLong((byte[])id, (int)0, (long)client.getId());
        Bytes.putInt((byte[])id, (int)12, (int)sequence);
        this._session = new sessionid4(id);
    }

    public sessionid4 id() {
        return this._session;
    }

    public NFS4Client getClient() {
        return this._client;
    }

    public int slotMax() {
        return this._slots.length - 1;
    }

    public List<nfs_resop4> checkCacheSlot(int slot, int sequence, boolean checkCache) throws ChimeraNFSException {
        return this.getSlot(slot).checkSlotSequence(sequence, checkCache);
    }

    private SessionSlot getSlot(int slot) throws ChimeraNFSException {
        if (slot < 0 || slot > this.slotMax()) {
            throw new ChimeraNFSException(10053, "slot id overflow");
        }
        if (this._slots[slot] == null) {
            this._slots[slot] = new SessionSlot();
        }
        return this._slots[slot];
    }

    public int getSequence() {
        return this._sequence;
    }

    public String toString() {
        return this._client.getRemoteAddress() + " : " + this.toHexString(this._session.value);
    }

    public String toHexString(byte[] data) {
        StringBuilder sb = new StringBuilder();
        for (byte b : data) {
            sb.append(Integer.toHexString(b));
        }
        return sb.toString();
    }

    public void updateSlotCache(int slot, List<nfs_resop4> reply) throws ChimeraNFSException {
        this.getSlot(slot).update(reply);
    }
}

