/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.nfs.v4;

import java.io.IOException;
import org.dcache.chimera.nfs.ChimeraNFSException;
import org.dcache.chimera.nfs.v4.AbstractNFSv4Operation;
import org.dcache.chimera.nfs.v4.CompoundContext;
import org.dcache.chimera.nfs.v4.NFS4State;
import org.dcache.chimera.nfs.v4.Stateids;
import org.dcache.chimera.nfs.v4.xdr.CLOSE4res;
import org.dcache.chimera.nfs.v4.xdr.nfs_argop4;
import org.dcache.chimera.nfs.v4.xdr.nfs_resop4;
import org.dcache.chimera.nfs.vfs.Inode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationCLOSE
extends AbstractNFSv4Operation {
    private static final Logger _log = LoggerFactory.getLogger(OperationCLOSE.class);

    OperationCLOSE(nfs_argop4 args) {
        super(args, 4);
    }

    @Override
    public void process(CompoundContext context, nfs_resop4 result) throws ChimeraNFSException {
        CLOSE4res res = result.opclose;
        Inode inode = context.currentInode();
        if (context.getMinorversion() > 0) {
            context.getSession().getClient().updateLeaseTime();
            NFS4State state = context.getSession().getClient().state(this._args.opclose.open_stateid);
            try {
                context.getDeviceManager().layoutReturn(context, this._args.opclose.open_stateid);
            }
            catch (IOException e) {
                _log.error("Failed to return a layout: {}", (Object)e.getMessage());
            }
        } else {
            context.getStateHandler().updateClientLeaseTime(this._args.opclose.open_stateid);
        }
        res.open_stateid = Stateids.invalidStateId();
        res.status = 0;
    }
}

