/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.nfs.v4.xdr;

import java.io.IOException;
import org.dcache.chimera.nfs.v4.xdr.uint32_t;
import org.dcache.xdr.OncRpcException;
import org.dcache.xdr.XdrAble;
import org.dcache.xdr.XdrDecodingStream;
import org.dcache.xdr.XdrEncodingStream;

public class bitmap4
implements XdrAble {
    public uint32_t[] value;

    public bitmap4() {
    }

    public bitmap4(uint32_t[] value) {
        this.value = value;
    }

    public bitmap4(XdrDecodingStream xdr) throws OncRpcException, IOException {
        this.xdrDecode(xdr);
    }

    public void xdrEncode(XdrEncodingStream xdr) throws OncRpcException, IOException {
        int $size = this.value.length;
        xdr.xdrEncodeInt($size);
        for (int $idx = 0; $idx < $size; ++$idx) {
            this.value[$idx].xdrEncode(xdr);
        }
    }

    public void xdrDecode(XdrDecodingStream xdr) throws OncRpcException, IOException {
        int $size = xdr.xdrDecodeInt();
        this.value = new uint32_t[$size];
        for (int $idx = 0; $idx < $size; ++$idx) {
            this.value[$idx] = new uint32_t(xdr);
        }
    }

    public static bitmap4 of(int ... values) {
        if (values.length == 0) {
            throw new IllegalArgumentException("No values provided");
        }
        int max = values[0];
        for (int v : values) {
            if (v <= max) continue;
            max = v;
        }
        int n = max / 32 + 1;
        bitmap4 bitmap = new bitmap4(new uint32_t[n]);
        for (int i = 0; i < n; ++i) {
            bitmap.value[i] = new uint32_t();
        }
        for (int v : values) {
            int bit = v - 32 * (v / 32);
            bitmap.value[v / 32].value |= 1 << bit;
        }
        return bitmap;
    }
}

