/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.nfs.vfs;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class FileHandle {
    private static final int MIN_LEN = 14;
    private static final int VERSION = 1;
    private static final int MAGIC = 13303790;
    private static final byte[] EMPTY_FH = new byte[0];
    private final int version;
    private final int magic;
    private final int generation;
    private final int exportIdx;
    private final int type;
    private final byte[] fs_opaque;

    public FileHandle(int generation, int exportIdx, int type, byte[] fs_opaque) {
        this.version = 1;
        this.magic = 13303790;
        this.generation = generation;
        this.exportIdx = exportIdx;
        this.type = type;
        this.fs_opaque = fs_opaque;
    }

    public FileHandle(byte[] bytes) {
        if (bytes.length < 14) {
            throw new IllegalArgumentException("too short");
        }
        ByteBuffer b = ByteBuffer.wrap(bytes);
        b.order(ByteOrder.BIG_ENDIAN);
        int magic_version = b.getInt();
        this.version = (magic_version & 0xFF000000) >>> 24;
        if (this.version != 1) {
            throw new IllegalArgumentException("Unsupported version: " + this.version);
        }
        this.magic = magic_version & 0xFFFFFF;
        if (this.magic != 13303790) {
            throw new IllegalArgumentException("Bad magic number");
        }
        this.generation = b.getInt();
        this.exportIdx = b.getInt();
        this.type = b.get();
        byte olen = b.get();
        this.fs_opaque = new byte[olen];
        b.get(this.fs_opaque);
    }

    public int getVersion() {
        return this.version;
    }

    public int getMagic() {
        return this.magic;
    }

    public int getGeneration() {
        return this.generation;
    }

    public int getExportIdx() {
        return this.exportIdx;
    }

    public int getType() {
        return this.type;
    }

    public byte[] getFsOpaque() {
        return this.fs_opaque;
    }

    public byte[] bytes() {
        int len = this.fs_opaque.length + 14;
        byte[] bytes = new byte[len];
        ByteBuffer b = ByteBuffer.wrap(bytes);
        b.order(ByteOrder.BIG_ENDIAN);
        b.putInt(this.version << 24 | this.magic);
        b.putInt(this.generation);
        b.putInt(this.exportIdx);
        b.put((byte)this.type);
        b.put((byte)this.fs_opaque.length);
        b.put(this.fs_opaque);
        return bytes;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (byte b : this.bytes()) {
            int i = b & 0xFF;
            if (i < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(i));
        }
        return sb.toString();
    }

    static /* synthetic */ byte[] access$000() {
        return EMPTY_FH;
    }

    public static class FileHandleBuilder {
        private int version = 1;
        private int magic = 13303790;
        private int generation = 0;
        private int export_idx = 0;
        private int type = 0;
        private byte[] fs_opaque = FileHandle.access$000();

        public FileHandleBuilder setGeneration(int generation) {
            this.generation = generation;
            return this;
        }

        public FileHandleBuilder setExportIdx(int export_idx) {
            this.export_idx = export_idx;
            return this;
        }

        public FileHandleBuilder setType(int type) {
            this.type = type;
            return this;
        }

        public FileHandleBuilder setFsOpaque(byte[] fs_opaque) {
            this.fs_opaque = fs_opaque;
            return this;
        }

        public FileHandle build(byte[] opaque) {
            return new FileHandle(this.generation, this.export_idx, this.type, opaque);
        }

        public FileHandle build() {
            return this.build(this.fs_opaque);
        }
    }
}

