/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.nfs.vfs;

import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.security.auth.Subject;
import org.dcache.auth.Subjects;
import org.dcache.chimera.nfs.ChimeraNFSException;
import org.dcache.chimera.nfs.ExportFile;
import org.dcache.chimera.nfs.FsExport;
import org.dcache.chimera.nfs.NfsUser;
import org.dcache.chimera.nfs.v4.acl.Acls;
import org.dcache.chimera.nfs.v4.xdr.acemask4;
import org.dcache.chimera.nfs.v4.xdr.nfsace4;
import org.dcache.chimera.nfs.vfs.ChimeraVfs;
import org.dcache.chimera.nfs.vfs.DirectoryEntry;
import org.dcache.chimera.nfs.vfs.FileHandle;
import org.dcache.chimera.nfs.vfs.FsStat;
import org.dcache.chimera.nfs.vfs.Inode;
import org.dcache.chimera.nfs.vfs.PseudoFsNode;
import org.dcache.chimera.nfs.vfs.Stat;
import org.dcache.chimera.nfs.vfs.VirtualFileSystem;
import org.dcache.xdr.RpcCall;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PseudoFs
implements VirtualFileSystem {
    private static final Logger _log = LoggerFactory.getLogger(PseudoFs.class);
    private final Subject _subject;
    private final InetAddress _inetAddress;
    private final VirtualFileSystem _inner;
    private final ExportFile _exportFile;
    private static final int BIT_MASK_OWNER_OFFSET = 6;
    private static final int BIT_MASK_GROUP_OFFSET = 3;
    private static final int BIT_MASK_OTHER_OFFSET = 0;

    public PseudoFs(VirtualFileSystem inner, RpcCall call, ExportFile exportFile) {
        this._inner = inner;
        this._subject = call.getCredential().getSubject();
        this._inetAddress = call.getTransport().getRemoteSocketAddress().getAddress();
        this._exportFile = exportFile;
    }

    private boolean canAccess(Inode inode, int mode) {
        try {
            this.checkAccess(inode, mode);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public int access(Inode inode, int mode) throws IOException {
        int accessmask = 0;
        if ((mode & 1) != 0 && this.canAccess(inode, 1)) {
            accessmask |= 1;
        }
        if ((mode & 2) != 0 && this.canAccess(inode, 32)) {
            accessmask |= 2;
        }
        if ((mode & 4) != 0 && this.canAccess(inode, 2)) {
            accessmask |= 4;
        }
        if ((mode & 0x20) != 0 && this.canAccess(inode, 32)) {
            accessmask |= 0x20;
        }
        if ((mode & 8) != 0 && this.canAccess(inode, 4)) {
            accessmask |= 8;
        }
        if ((mode & 0x10) != 0 && this.canAccess(inode, 64)) {
            accessmask |= 0x10;
        }
        return accessmask;
    }

    @Override
    public Inode create(Inode parent, Stat.Type type, String path, int uid, int gid, int mode) throws IOException {
        this.checkAccess(parent, 2);
        return this.pushExportIndex(parent, this._inner.create(parent, type, path, uid, gid, mode));
    }

    @Override
    public FsStat getFsStat() throws IOException {
        return this._inner.getFsStat();
    }

    @Override
    public Inode getRootInode() throws IOException {
        return this.realToPseudo(this._inner.getRootInode());
    }

    @Override
    public Inode lookup(Inode parent, String path) throws IOException {
        this.checkAccess(parent, 32);
        if (parent.isPesudoInode()) {
            return this.lookupInPseudoDirectory(parent, path);
        }
        return this.pushExportIndex(parent, this._inner.lookup(parent, path));
    }

    @Override
    public Inode link(Inode parent, Inode link, String path, int uid, int gid) throws IOException {
        this.checkAccess(parent, 2);
        return this.pushExportIndex(parent, this._inner.link(parent, link, path, uid, gid));
    }

    @Override
    public List<DirectoryEntry> list(Inode inode) throws IOException {
        this.checkAccess(inode, 1);
        if (inode.isPesudoInode()) {
            return this.listPseudoDirectory(inode);
        }
        return Lists.transform(this._inner.list(inode), (Function)new PushParentIndex(inode));
    }

    @Override
    public Inode mkdir(Inode parent, String path, int uid, int gid, int mode) throws IOException {
        this.checkAccess(parent, 4);
        return this.pushExportIndex(parent, this._inner.mkdir(parent, path, uid, gid, mode));
    }

    @Override
    public void move(Inode src, String oldName, Inode dest, String newName) throws IOException {
        this.checkAccess(src, 64);
        this.checkAccess(dest, 66);
        this._inner.move(src, oldName, dest, newName);
    }

    @Override
    public Inode parentOf(Inode inode) throws IOException {
        return this.pushExportIndex(inode, this._inner.parentOf(inode));
    }

    @Override
    public int read(Inode inode, byte[] data, long offset, int count) throws IOException {
        this.checkAccess(inode, 1);
        return this._inner.read(inode, data, offset, count);
    }

    @Override
    public String readlink(Inode inode) throws IOException {
        this.checkAccess(inode, 1);
        return this._inner.readlink(inode);
    }

    @Override
    public boolean remove(Inode parent, String path) throws IOException {
        try {
            this.checkAccess(parent, 64);
        }
        catch (ChimeraNFSException e) {
            if (e.getStatus() == 13) {
                Inode inode = this.pushExportIndex(parent, this._inner.lookup(parent, path));
                this.checkAccess(inode, 65536);
            }
            throw e;
        }
        return this._inner.remove(parent, path);
    }

    @Override
    public Inode symlink(Inode parent, String path, String link, int uid, int gid, int mode) throws IOException {
        this.checkAccess(parent, 2);
        return this.pushExportIndex(parent, this._inner.symlink(parent, path, link, uid, gid, mode));
    }

    @Override
    public int write(Inode inode, byte[] data, long offset, int count) throws IOException {
        this.checkAccess(inode, 2);
        return this._inner.write(inode, data, offset, count);
    }

    @Override
    public Stat getattr(Inode inode) throws IOException {
        this.checkAccess(inode, 128);
        return this._inner.getattr(inode);
    }

    @Override
    public void setattr(Inode inode, Stat stat) throws IOException {
        this.checkAccess(inode, 256);
        this._inner.setattr(inode, stat);
    }

    @Override
    public nfsace4[] getAcl(Inode inode) throws IOException {
        this.checkAccess(inode, 131072);
        return this._inner.getAcl(inode);
    }

    @Override
    public void setAcl(Inode inode, nfsace4[] acl) throws IOException {
        this.checkAccess(inode, 262144);
        this._inner.setAcl(inode, acl);
    }

    private void checkAccess(Inode inode, int requestedMask) throws IOException {
        int unixAccessmask;
        Subject effectiveSubject = this._subject;
        Stat stat = this._inner.getattr(inode);
        boolean aclMatched = false;
        if (inode.isPesudoInode() && Acls.wantModify(requestedMask)) {
            _log.warn("Access Deny: pseudo Inode {} {} {}", new Object[]{inode, acemask4.toString(requestedMask), effectiveSubject});
            throw new ChimeraNFSException(30, "attempt to modify pseudofs");
        }
        if (!inode.isPesudoInode()) {
            int exportIdx = inode.exportIndex();
            FsExport export = this._exportFile.getExport(exportIdx, this._inetAddress);
            if (exportIdx != 0 && export == null) {
                _log.warn("Access Deny (no export) to inode {} for client {}", (Object)inode, (Object)this._inetAddress);
                throw new ChimeraNFSException(13, "permission deny");
            }
            if (export.ioMode() == FsExport.IO.RO && Acls.wantModify(requestedMask)) {
                _log.warn("Access Deny (RO export) inode {} for client {}", (Object)inode, (Object)this._inetAddress);
                throw new ChimeraNFSException(13, "read-only export");
            }
            if (!export.isTrusted() && Subjects.isRoot((Subject)this._subject)) {
                effectiveSubject = NfsUser.NFS_NOBODY;
            }
            if (export.checkAcls()) {
                ChimeraVfs chimeraVfs = (ChimeraVfs)this._inner;
                aclMatched = chimeraVfs.checkAclAccess(this._subject, inode, requestedMask);
            }
        }
        if (!aclMatched && ((unixAccessmask = this.unixToAccessmask(effectiveSubject, stat)) & requestedMask) != requestedMask) {
            _log.warn("Access Deny: {} {} {} {}", new Object[]{inode, acemask4.toString(requestedMask), acemask4.toString(unixAccessmask), this._subject});
            throw new ChimeraNFSException(13, "permission deny");
        }
    }

    private int unixToAccessmask(Subject subject, Stat stat) {
        boolean isDir;
        int mode = stat.getMode();
        boolean bl = isDir = (mode & 0x4000) == 16384;
        int fromUnixMask = Subjects.hasUid((Subject)subject, (long)stat.getUid()) ? Acls.toAccessMask(mode >> 6, isDir, true) : (Subjects.hasGid((Subject)subject, (long)stat.getGid()) ? Acls.toAccessMask(mode >> 3, isDir, false) : Acls.toAccessMask(mode >> 0, isDir, false));
        return fromUnixMask;
    }

    private Inode lookupInPseudoDirectory(Inode parent, String name2) throws IOException {
        Set<PseudoFsNode> nodes = this.prepareExportTree();
        for (PseudoFsNode node : nodes) {
            PseudoFsNode n;
            if (!node.id().equals(parent) || (n = node.getChild(name2)) == null) continue;
            return n.isMountPoint() ? this.pseudoIdToReal(n.id(), this.getIndexId(n)) : n.id();
        }
        throw new ChimeraNFSException(2, "");
    }

    private Inode pseudoIdToReal(Inode inode, int index) {
        FileHandle fh = new FileHandle.FileHandleBuilder().setExportIdx(index).setType(0).build(inode.getFileId());
        return new Inode(fh);
    }

    private int getIndexId(PseudoFsNode node) {
        List<FsExport> exports2 = node.getExports();
        return exports2.get(0).getIndex();
    }

    private List<DirectoryEntry> listPseudoDirectory(Inode parent) throws ChimeraNFSException, IOException {
        Set<PseudoFsNode> nodes = this.prepareExportTree();
        for (PseudoFsNode node : nodes) {
            if (!node.id().equals(parent)) continue;
            if (node.isMountPoint()) {
                return Lists.transform(this._inner.list(parent), (Function)new ConvertToRealInode(node));
            }
            ArrayList<DirectoryEntry> pseudoLs = new ArrayList<DirectoryEntry>();
            for (String s : node.getChildren()) {
                PseudoFsNode subNode = node.getChild(s);
                Inode inode = subNode.id();
                Stat stat = this._inner.getattr(inode);
                DirectoryEntry e = new DirectoryEntry(s, subNode.isMountPoint() ? this.pseudoIdToReal(inode, this.getIndexId(subNode)) : inode, stat);
                pseudoLs.add(e);
            }
            return pseudoLs;
        }
        throw new ChimeraNFSException(2, "");
    }

    private Inode pushExportIndex(Inode parent, Inode inode) {
        FileHandle fh = new FileHandle.FileHandleBuilder().setExportIdx(parent.exportIndex()).setType(0).build(inode.getFileId());
        return new Inode(fh);
    }

    private Inode realToPseudo(Inode inode) {
        return this.realToPseudo(inode, 0);
    }

    private Inode realToPseudo(Inode inode, int idx) {
        FileHandle fh = new FileHandle.FileHandleBuilder().setExportIdx(idx).setType(1).build(inode.getFileId());
        return new Inode(fh);
    }

    private void pathToPseudoFs(PseudoFsNode root, Set<PseudoFsNode> all, FsExport e) throws IOException {
        PseudoFsNode parent = root;
        String path = e.getPath();
        if (e.getPath().equals("/")) {
            root.addExport(e);
            return;
        }
        Splitter splitter = Splitter.on((char)'/').omitEmptyStrings();
        HashSet<PseudoFsNode> pathNodes = new HashSet<PseudoFsNode>();
        for (String s : splitter.split((CharSequence)path)) {
            try {
                PseudoFsNode node = parent.getChild(s);
                if (node == null) {
                    node = new PseudoFsNode(this.realToPseudo(this._inner.lookup(parent.id(), s)));
                    parent.addChild(s, node);
                    pathNodes.add(node);
                }
                parent = node;
            }
            catch (IOException ef) {
                return;
            }
        }
        all.addAll(pathNodes);
        parent.setId(this.pseudoIdToReal(parent.id(), e.getIndex()));
        parent.addExport(e);
    }

    private Set<PseudoFsNode> prepareExportTree() throws ChimeraNFSException, IOException {
        Collection<FsExport> exports2 = this._exportFile.exportsFor(this._inetAddress);
        if (exports2.isEmpty()) {
            _log.warn("No exports found for: " + this._inetAddress);
            throw new ChimeraNFSException(13, "");
        }
        HashSet<PseudoFsNode> nodes = new HashSet<PseudoFsNode>();
        Inode rootInode = this.realToPseudo(this._inner.getRootInode());
        PseudoFsNode root = new PseudoFsNode(rootInode);
        for (FsExport export : exports2) {
            this.pathToPseudoFs(root, nodes, export);
        }
        nodes.add(root);
        return nodes;
    }

    private class PushParentIndex
    implements Function<DirectoryEntry, DirectoryEntry> {
        private final Inode _inode;

        PushParentIndex(Inode parent) {
            this._inode = parent;
        }

        public DirectoryEntry apply(DirectoryEntry input) {
            return new DirectoryEntry(input.getName(), PseudoFs.this.pushExportIndex(this._inode, input.getInode()), input.getStat());
        }
    }

    private class ConvertToRealInode
    implements Function<DirectoryEntry, DirectoryEntry> {
        private final PseudoFsNode _node;

        ConvertToRealInode(PseudoFsNode node) {
            this._node = node;
        }

        public DirectoryEntry apply(DirectoryEntry input) {
            return new DirectoryEntry(input.getName(), PseudoFs.this.pseudoIdToReal(input.getInode(), PseudoFs.this.getIndexId(this._node)), input.getStat());
        }
    }
}

