/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.nfs;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IPMatcher {
    private static final int IPv4_FULL_MASK = 32;
    private static final int IPv6_FULL_MASK = 128;
    private static final int IPv6_HALF_MASK = 64;

    public static boolean match(String pattern, InetAddress ip) {
        InetAddress[] addresses;
        if (pattern.indexOf(42) != -1 || pattern.indexOf(63) != -1) {
            String hostName = ip.getHostName();
            return IPMatcher.match(pattern, hostName);
        }
        String[] ipMask = pattern.split("/");
        if (ipMask.length > 2) {
            return false;
        }
        int mask = ipMask.length == 2 ? Integer.parseInt(ipMask[1]) : IPMatcher.fullMaskOf(ip);
        try {
            addresses = InetAddress.getAllByName(ipMask[0]);
        }
        catch (UnknownHostException uhe) {
            return false;
        }
        for (InetAddress address : addresses) {
            if (!IPMatcher.match(address, ip, mask)) continue;
            return true;
        }
        return false;
    }

    public static boolean match(String pattern, String hostName) {
        Pattern p = Pattern.compile(IPMatcher.toRegExp(pattern));
        Matcher m = p.matcher(hostName);
        return m.matches();
    }

    public static boolean match(InetAddress ip, InetAddress subnet, int mask) {
        Preconditions.checkArgument((mask >= 0 ? 1 : 0) != 0, (Object)"Netmask should be positive");
        byte[] ipBytes = ip.getAddress();
        byte[] netBytes = subnet.getAddress();
        if (ipBytes.length != netBytes.length) {
            return false;
        }
        if (ipBytes.length == 4) {
            Preconditions.checkArgument((mask <= 32 ? 1 : 0) != 0, (Object)"Netmask for ipv4 can't be bigger than32");
            int ipAsInt = Ints.fromByteArray((byte[])ipBytes);
            int netAsBytes = Ints.fromByteArray((byte[])netBytes);
            return (ipAsInt ^ netAsBytes) >> 32 - mask == 0;
        }
        Preconditions.checkArgument((mask <= 128 ? 1 : 0) != 0, (Object)"Netmask for ipv6 can't be bigger than128");
        long ipAsLong0 = Longs.fromBytes((byte)ipBytes[0], (byte)ipBytes[1], (byte)ipBytes[2], (byte)ipBytes[3], (byte)ipBytes[4], (byte)ipBytes[5], (byte)ipBytes[6], (byte)ipBytes[7]);
        long netAsLong0 = Longs.fromBytes((byte)netBytes[0], (byte)netBytes[1], (byte)netBytes[2], (byte)netBytes[3], (byte)netBytes[4], (byte)netBytes[5], (byte)netBytes[6], (byte)netBytes[7]);
        if (mask > 64) {
            long ipAsLong1 = Longs.fromBytes((byte)ipBytes[8], (byte)ipBytes[9], (byte)ipBytes[10], (byte)ipBytes[11], (byte)ipBytes[12], (byte)ipBytes[13], (byte)ipBytes[14], (byte)ipBytes[15]);
            long netAsLong1 = Longs.fromBytes((byte)netBytes[8], (byte)netBytes[9], (byte)netBytes[10], (byte)netBytes[11], (byte)netBytes[12], (byte)netBytes[13], (byte)netBytes[14], (byte)netBytes[15]);
            return ipAsLong0 == netAsLong0 & (ipAsLong1 ^ netAsLong1) >> 128 - mask == 0L;
        }
        return (ipAsLong0 ^ netAsLong0) >> 64 - mask == 0L;
    }

    private static String toRegExp(String s) {
        return s.replace(".", "\\.").replace("?", ".").replace("*", ".*");
    }

    private static int fullMaskOf(InetAddress address) {
        if (address instanceof Inet4Address) {
            return 32;
        }
        if (address instanceof Inet6Address) {
            return 128;
        }
        throw new IllegalArgumentException("Unsupported Inet type: " + address.getClass().getName());
    }
}

