/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.nfs.v4;

import java.security.SecureRandom;
import org.dcache.chimera.nfs.v4.xdr.stateid4;
import org.dcache.chimera.nfs.v4.xdr.uint32_t;
import org.dcache.utils.Bytes;

class NFS4State {
    private final stateid4 _stateid = new stateid4();
    private boolean _isConfimed = false;
    private static final SecureRandom RANDOM = new SecureRandom();

    public NFS4State(long clientid, int seqid) {
        this._stateid.other = new byte[12];
        this._stateid.seqid = new uint32_t(seqid);
        Bytes.putLong((byte[])this._stateid.other, (int)0, (long)clientid);
        Bytes.putInt((byte[])this._stateid.other, (int)8, (int)RANDOM.nextInt());
    }

    public void bumpSeqid() {
        ++this._stateid.seqid.value;
    }

    public stateid4 stateid() {
        return this._stateid;
    }

    public void confirm() {
        this._isConfimed = true;
    }

    public boolean isConfimed() {
        return this._isConfimed;
    }
}

