/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.nfs.v4;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import org.dcache.chimera.nfs.ChimeraNFSException;

class NameFilter {
    private static final Charset UTF8 = Charset.forName("UTF-8");

    private NameFilter() {
    }

    public static String convert(byte[] bytes) throws ChimeraNFSException {
        if (bytes.length == 0) {
            throw new ChimeraNFSException(22, "zero-length name");
        }
        if (bytes.length > 255) {
            throw new ChimeraNFSException(63, "file name too long");
        }
        try {
            CharsetDecoder cd = UTF8.newDecoder();
            cd.onMalformedInput(CodingErrorAction.REPORT);
            ByteBuffer uniBuf = ByteBuffer.wrap(bytes);
            CharBuffer charBuf = cd.decode(uniBuf);
            return new String(charBuf.array(), 0, charBuf.length());
        }
        catch (CharacterCodingException e) {
            throw new ChimeraNFSException(22, "invalid utf8 name");
        }
    }
}

